package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.ErrorMessage
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FileCacheFailureDetails(
    message: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.FileCacheFailureDetails = {
    import FileCacheFailureDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.FileCacheFailureDetails
      .builder()
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.FileCacheFailureDetails.ReadOnly =
    zio.aws.fsx.model.FileCacheFailureDetails.wrap(buildAwsValue())
}
object FileCacheFailureDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.FileCacheFailureDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.FileCacheFailureDetails =
      zio.aws.fsx.model.FileCacheFailureDetails(message.map(value => value))
    def message: Optional[ErrorMessage]
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.FileCacheFailureDetails
  ) extends zio.aws.fsx.model.FileCacheFailureDetails.ReadOnly {
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.fsx.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.FileCacheFailureDetails
  ): zio.aws.fsx.model.FileCacheFailureDetails.ReadOnly = new Wrapper(impl)
}
