package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait FileCacheLifecycle {
  def unwrap: software.amazon.awssdk.services.fsx.model.FileCacheLifecycle
}
object FileCacheLifecycle {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.FileCacheLifecycle
  ): zio.aws.fsx.model.FileCacheLifecycle = value match {
    case software.amazon.awssdk.services.fsx.model.FileCacheLifecycle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.FileCacheLifecycle.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.fsx.model.FileCacheLifecycle.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.fsx.model.FileCacheLifecycle.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.fsx.model.FileCacheLifecycle.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.fsx.model.FileCacheLifecycle.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.FileCacheLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileCacheLifecycle =
      software.amazon.awssdk.services.fsx.model.FileCacheLifecycle.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.fsx.model.FileCacheLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileCacheLifecycle =
      software.amazon.awssdk.services.fsx.model.FileCacheLifecycle.AVAILABLE
  }
  case object CREATING extends zio.aws.fsx.model.FileCacheLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileCacheLifecycle =
      software.amazon.awssdk.services.fsx.model.FileCacheLifecycle.CREATING
  }
  case object DELETING extends zio.aws.fsx.model.FileCacheLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileCacheLifecycle =
      software.amazon.awssdk.services.fsx.model.FileCacheLifecycle.DELETING
  }
  case object UPDATING extends zio.aws.fsx.model.FileCacheLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileCacheLifecycle =
      software.amazon.awssdk.services.fsx.model.FileCacheLifecycle.UPDATING
  }
  case object FAILED extends zio.aws.fsx.model.FileCacheLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileCacheLifecycle =
      software.amazon.awssdk.services.fsx.model.FileCacheLifecycle.FAILED
  }
}
