package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.IpAddress
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FileCacheNFSConfiguration(
    version: zio.aws.fsx.model.NfsVersion,
    dnsIps: Optional[Iterable[IpAddress]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.FileCacheNFSConfiguration = {
    import FileCacheNFSConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.FileCacheNFSConfiguration
      .builder()
      .version(version.unwrap)
      .optionallyWith(
        dnsIps.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dnsIps)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.FileCacheNFSConfiguration.ReadOnly =
    zio.aws.fsx.model.FileCacheNFSConfiguration.wrap(buildAwsValue())
}
object FileCacheNFSConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.FileCacheNFSConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.FileCacheNFSConfiguration =
      zio.aws.fsx.model
        .FileCacheNFSConfiguration(version, dnsIps.map(value => value))
    def version: zio.aws.fsx.model.NfsVersion
    def dnsIps: Optional[List[IpAddress]]
    def getVersion: ZIO[Any, Nothing, zio.aws.fsx.model.NfsVersion] =
      ZIO.succeed(version)
    def getDnsIps: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("dnsIps", dnsIps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.FileCacheNFSConfiguration
  ) extends zio.aws.fsx.model.FileCacheNFSConfiguration.ReadOnly {
    override val version: zio.aws.fsx.model.NfsVersion =
      zio.aws.fsx.model.NfsVersion.wrap(impl.version())
    override val dnsIps: Optional[List[IpAddress]] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsIps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.IpAddress(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.FileCacheNFSConfiguration
  ): zio.aws.fsx.model.FileCacheNFSConfiguration.ReadOnly = new Wrapper(impl)
}
