package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait FileCacheType {
  def unwrap: software.amazon.awssdk.services.fsx.model.FileCacheType
}
object FileCacheType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.FileCacheType
  ): zio.aws.fsx.model.FileCacheType = value match {
    case software.amazon.awssdk.services.fsx.model.FileCacheType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.FileCacheType.LUSTRE =>
      val r = LUSTRE
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.FileCacheType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileCacheType =
      software.amazon.awssdk.services.fsx.model.FileCacheType.UNKNOWN_TO_SDK_VERSION
  }
  case object LUSTRE extends zio.aws.fsx.model.FileCacheType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileCacheType =
      software.amazon.awssdk.services.fsx.model.FileCacheType.LUSTRE
  }
}
