package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.IpAddress
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NFSDataRepositoryConfiguration(
    version: zio.aws.fsx.model.NfsVersion,
    dnsIps: Optional[Iterable[IpAddress]] = Optional.Absent,
    autoExportPolicy: Optional[zio.aws.fsx.model.AutoExportPolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.NFSDataRepositoryConfiguration = {
    import NFSDataRepositoryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.NFSDataRepositoryConfiguration
      .builder()
      .version(version.unwrap)
      .optionallyWith(
        dnsIps.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dnsIps)
      .optionallyWith(autoExportPolicy.map(value => value.buildAwsValue()))(
        _.autoExportPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.NFSDataRepositoryConfiguration.ReadOnly =
    zio.aws.fsx.model.NFSDataRepositoryConfiguration.wrap(buildAwsValue())
}
object NFSDataRepositoryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.NFSDataRepositoryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.NFSDataRepositoryConfiguration =
      zio.aws.fsx.model.NFSDataRepositoryConfiguration(
        version,
        dnsIps.map(value => value),
        autoExportPolicy.map(value => value.asEditable)
      )
    def version: zio.aws.fsx.model.NfsVersion
    def dnsIps: Optional[List[IpAddress]]
    def autoExportPolicy: Optional[zio.aws.fsx.model.AutoExportPolicy.ReadOnly]
    def getVersion: ZIO[Any, Nothing, zio.aws.fsx.model.NfsVersion] =
      ZIO.succeed(version)
    def getDnsIps: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("dnsIps", dnsIps)
    def getAutoExportPolicy
        : ZIO[Any, AwsError, zio.aws.fsx.model.AutoExportPolicy.ReadOnly] =
      AwsError.unwrapOptionField("autoExportPolicy", autoExportPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.NFSDataRepositoryConfiguration
  ) extends zio.aws.fsx.model.NFSDataRepositoryConfiguration.ReadOnly {
    override val version: zio.aws.fsx.model.NfsVersion =
      zio.aws.fsx.model.NfsVersion.wrap(impl.version())
    override val dnsIps: Optional[List[IpAddress]] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsIps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.IpAddress(item)
        }.toList
      )
    override val autoExportPolicy
        : Optional[zio.aws.fsx.model.AutoExportPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoExportPolicy())
        .map(value => zio.aws.fsx.model.AutoExportPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.NFSDataRepositoryConfiguration
  ): zio.aws.fsx.model.NFSDataRepositoryConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
