package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  IpAddress,
  DirectoryPassword,
  FileSystemAdministratorsGroupName,
  ActiveDirectoryFullyQualifiedName,
  OrganizationalUnitDistinguishedName,
  DirectoryUserName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SelfManagedActiveDirectoryConfiguration(
    domainName: ActiveDirectoryFullyQualifiedName,
    organizationalUnitDistinguishedName: Optional[
      OrganizationalUnitDistinguishedName
    ] = Optional.Absent,
    fileSystemAdministratorsGroup: Optional[FileSystemAdministratorsGroupName] =
      Optional.Absent,
    userName: DirectoryUserName,
    password: DirectoryPassword,
    dnsIps: Iterable[IpAddress]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryConfiguration = {
    import SelfManagedActiveDirectoryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryConfiguration
      .builder()
      .domainName(
        ActiveDirectoryFullyQualifiedName.unwrap(domainName): java.lang.String
      )
      .optionallyWith(
        organizationalUnitDistinguishedName.map(value =>
          OrganizationalUnitDistinguishedName.unwrap(value): java.lang.String
        )
      )(_.organizationalUnitDistinguishedName)
      .optionallyWith(
        fileSystemAdministratorsGroup.map(value =>
          FileSystemAdministratorsGroupName.unwrap(value): java.lang.String
        )
      )(_.fileSystemAdministratorsGroup)
      .userName(DirectoryUserName.unwrap(userName): java.lang.String)
      .password(DirectoryPassword.unwrap(password): java.lang.String)
      .dnsIps(dnsIps.map { item =>
        IpAddress.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration.ReadOnly =
    zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration
      .wrap(buildAwsValue())
}
object SelfManagedActiveDirectoryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration =
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration(
        domainName,
        organizationalUnitDistinguishedName.map(value => value),
        fileSystemAdministratorsGroup.map(value => value),
        userName,
        password,
        dnsIps
      )
    def domainName: ActiveDirectoryFullyQualifiedName
    def organizationalUnitDistinguishedName
        : Optional[OrganizationalUnitDistinguishedName]
    def fileSystemAdministratorsGroup
        : Optional[FileSystemAdministratorsGroupName]
    def userName: DirectoryUserName
    def password: DirectoryPassword
    def dnsIps: List[IpAddress]
    def getDomainName: ZIO[Any, Nothing, ActiveDirectoryFullyQualifiedName] =
      ZIO.succeed(domainName)
    def getOrganizationalUnitDistinguishedName
        : ZIO[Any, AwsError, OrganizationalUnitDistinguishedName] =
      AwsError.unwrapOptionField(
        "organizationalUnitDistinguishedName",
        organizationalUnitDistinguishedName
      )
    def getFileSystemAdministratorsGroup
        : ZIO[Any, AwsError, FileSystemAdministratorsGroupName] =
      AwsError.unwrapOptionField(
        "fileSystemAdministratorsGroup",
        fileSystemAdministratorsGroup
      )
    def getUserName: ZIO[Any, Nothing, DirectoryUserName] =
      ZIO.succeed(userName)
    def getPassword: ZIO[Any, Nothing, DirectoryPassword] =
      ZIO.succeed(password)
    def getDnsIps: ZIO[Any, Nothing, List[IpAddress]] = ZIO.succeed(dnsIps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryConfiguration
  ) extends zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration.ReadOnly {
    override val domainName: ActiveDirectoryFullyQualifiedName =
      zio.aws.fsx.model.primitives
        .ActiveDirectoryFullyQualifiedName(impl.domainName())
    override val organizationalUnitDistinguishedName
        : Optional[OrganizationalUnitDistinguishedName] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationalUnitDistinguishedName())
      .map(value =>
        zio.aws.fsx.model.primitives.OrganizationalUnitDistinguishedName(value)
      )
    override val fileSystemAdministratorsGroup
        : Optional[FileSystemAdministratorsGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemAdministratorsGroup())
      .map(value =>
        zio.aws.fsx.model.primitives.FileSystemAdministratorsGroupName(value)
      )
    override val userName: DirectoryUserName =
      zio.aws.fsx.model.primitives.DirectoryUserName(impl.userName())
    override val password: DirectoryPassword =
      zio.aws.fsx.model.primitives.DirectoryPassword(impl.password())
    override val dnsIps: List[IpAddress] = impl
      .dnsIps()
      .asScala
      .map { item =>
        zio.aws.fsx.model.primitives.IpAddress(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryConfiguration
  ): zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration.ReadOnly =
    new Wrapper(impl)
}
