package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  IpAddress,
  DirectoryPassword,
  DirectoryUserName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SelfManagedActiveDirectoryConfigurationUpdates(
    userName: Optional[DirectoryUserName] = Optional.Absent,
    password: Optional[DirectoryPassword] = Optional.Absent,
    dnsIps: Optional[Iterable[IpAddress]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates = {
    import SelfManagedActiveDirectoryConfigurationUpdates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates
      .builder()
      .optionallyWith(
        userName.map(value => DirectoryUserName.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        password.map(value => DirectoryPassword.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(
        dnsIps.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dnsIps)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates.ReadOnly =
    zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates
      .wrap(buildAwsValue())
}
object SelfManagedActiveDirectoryConfigurationUpdates {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates =
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates(
        userName.map(value => value),
        password.map(value => value),
        dnsIps.map(value => value)
      )
    def userName: Optional[DirectoryUserName]
    def password: Optional[DirectoryPassword]
    def dnsIps: Optional[List[IpAddress]]
    def getUserName: ZIO[Any, AwsError, DirectoryUserName] =
      AwsError.unwrapOptionField("userName", userName)
    def getPassword: ZIO[Any, AwsError, DirectoryPassword] =
      AwsError.unwrapOptionField("password", password)
    def getDnsIps: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("dnsIps", dnsIps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates
  ) extends zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates.ReadOnly {
    override val userName: Optional[DirectoryUserName] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.fsx.model.primitives.DirectoryUserName(value))
    override val password: Optional[DirectoryPassword] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => zio.aws.fsx.model.primitives.DirectoryPassword(value))
    override val dnsIps: Optional[List[IpAddress]] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsIps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.IpAddress(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates
  ): zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates.ReadOnly =
    new Wrapper(impl)
}
