package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait Status {
  def unwrap: software.amazon.awssdk.services.fsx.model.Status
}
object Status {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.Status
  ): zio.aws.fsx.model.Status = value match {
    case software.amazon.awssdk.services.fsx.model.Status.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.Status.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.fsx.model.Status.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.fsx.model.Status.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.fsx.model.Status.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.fsx.model.Status.UPDATED_OPTIMIZING =>
      val r = UPDATED_OPTIMIZING
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.Status {
    override def unwrap: software.amazon.awssdk.services.fsx.model.Status =
      software.amazon.awssdk.services.fsx.model.Status.UNKNOWN_TO_SDK_VERSION
  }
  case object FAILED extends zio.aws.fsx.model.Status {
    override def unwrap: software.amazon.awssdk.services.fsx.model.Status =
      software.amazon.awssdk.services.fsx.model.Status.FAILED
  }
  case object IN_PROGRESS extends zio.aws.fsx.model.Status {
    override def unwrap: software.amazon.awssdk.services.fsx.model.Status =
      software.amazon.awssdk.services.fsx.model.Status.IN_PROGRESS
  }
  case object PENDING extends zio.aws.fsx.model.Status {
    override def unwrap: software.amazon.awssdk.services.fsx.model.Status =
      software.amazon.awssdk.services.fsx.model.Status.PENDING
  }
  case object COMPLETED extends zio.aws.fsx.model.Status {
    override def unwrap: software.amazon.awssdk.services.fsx.model.Status =
      software.amazon.awssdk.services.fsx.model.Status.COMPLETED
  }
  case object UPDATED_OPTIMIZING extends zio.aws.fsx.model.Status {
    override def unwrap: software.amazon.awssdk.services.fsx.model.Status =
      software.amazon.awssdk.services.fsx.model.Status.UPDATED_OPTIMIZING
  }
}
