package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.fsx.model.primitives.ResourceARN
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceARN: ResourceARN,
    tags: Iterable[zio.aws.fsx.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.TagResourceRequest
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.TagResourceRequest.ReadOnly =
    zio.aws.fsx.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.TagResourceRequest =
      zio.aws.fsx.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: ResourceARN
    def tags: List[zio.aws.fsx.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
    def getTags: ZIO[Any, Nothing, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.TagResourceRequest
  ) extends zio.aws.fsx.model.TagResourceRequest.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.fsx.model.primitives.ResourceARN(impl.resourceARN())
    override val tags: List[zio.aws.fsx.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.fsx.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.TagResourceRequest
  ): zio.aws.fsx.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
