package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{ClientRequestToken, FileCacheId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFileCacheRequest(
    fileCacheId: FileCacheId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    lustreConfiguration: Optional[
      zio.aws.fsx.model.UpdateFileCacheLustreConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateFileCacheRequest = {
    import UpdateFileCacheRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateFileCacheRequest
      .builder()
      .fileCacheId(FileCacheId.unwrap(fileCacheId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(lustreConfiguration.map(value => value.buildAwsValue()))(
        _.lustreConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.UpdateFileCacheRequest.ReadOnly =
    zio.aws.fsx.model.UpdateFileCacheRequest.wrap(buildAwsValue())
}
object UpdateFileCacheRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateFileCacheRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateFileCacheRequest =
      zio.aws.fsx.model.UpdateFileCacheRequest(
        fileCacheId,
        clientRequestToken.map(value => value),
        lustreConfiguration.map(value => value.asEditable)
      )
    def fileCacheId: FileCacheId
    def clientRequestToken: Optional[ClientRequestToken]
    def lustreConfiguration: Optional[
      zio.aws.fsx.model.UpdateFileCacheLustreConfiguration.ReadOnly
    ]
    def getFileCacheId: ZIO[Any, Nothing, FileCacheId] =
      ZIO.succeed(fileCacheId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getLustreConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.UpdateFileCacheLustreConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("lustreConfiguration", lustreConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileCacheRequest
  ) extends zio.aws.fsx.model.UpdateFileCacheRequest.ReadOnly {
    override val fileCacheId: FileCacheId =
      zio.aws.fsx.model.primitives.FileCacheId(impl.fileCacheId())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val lustreConfiguration: Optional[
      zio.aws.fsx.model.UpdateFileCacheLustreConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lustreConfiguration())
      .map(value =>
        zio.aws.fsx.model.UpdateFileCacheLustreConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileCacheRequest
  ): zio.aws.fsx.model.UpdateFileCacheRequest.ReadOnly = new Wrapper(impl)
}
