package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateVolumeResponse(
    volume: Optional[zio.aws.fsx.model.Volume] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateVolumeResponse = {
    import UpdateVolumeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateVolumeResponse
      .builder()
      .optionallyWith(volume.map(value => value.buildAwsValue()))(_.volume)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.UpdateVolumeResponse.ReadOnly =
    zio.aws.fsx.model.UpdateVolumeResponse.wrap(buildAwsValue())
}
object UpdateVolumeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateVolumeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateVolumeResponse = zio.aws.fsx.model
      .UpdateVolumeResponse(volume.map(value => value.asEditable))
    def volume: Optional[zio.aws.fsx.model.Volume.ReadOnly]
    def getVolume: ZIO[Any, AwsError, zio.aws.fsx.model.Volume.ReadOnly] =
      AwsError.unwrapOptionField("volume", volume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateVolumeResponse
  ) extends zio.aws.fsx.model.UpdateVolumeResponse.ReadOnly {
    override val volume: Optional[zio.aws.fsx.model.Volume.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volume())
        .map(value => zio.aws.fsx.model.Volume.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateVolumeResponse
  ): zio.aws.fsx.model.UpdateVolumeResponse.ReadOnly = new Wrapper(impl)
}
