package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  SubnetId,
  SecurityGroupId,
  FileSystemTypeVersion,
  ClientRequestToken,
  StorageCapacity,
  CopyTagsToDataRepositoryAssociations,
  KmsKeyId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateFileCacheRequest(
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    fileCacheType: zio.aws.fsx.model.FileCacheType,
    fileCacheTypeVersion: FileSystemTypeVersion,
    storageCapacity: StorageCapacity,
    subnetIds: Iterable[SubnetId],
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent,
    copyTagsToDataRepositoryAssociations: Optional[
      CopyTagsToDataRepositoryAssociations
    ] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    lustreConfiguration: Optional[
      zio.aws.fsx.model.CreateFileCacheLustreConfiguration
    ] = Optional.Absent,
    dataRepositoryAssociations: Optional[
      Iterable[zio.aws.fsx.model.FileCacheDataRepositoryAssociation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateFileCacheRequest = {
    import CreateFileCacheRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateFileCacheRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .fileCacheType(fileCacheType.unwrap)
      .fileCacheTypeVersion(
        FileSystemTypeVersion.unwrap(fileCacheTypeVersion): java.lang.String
      )
      .storageCapacity(StorageCapacity.unwrap(storageCapacity): Integer)
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        copyTagsToDataRepositoryAssociations.map(value =>
          CopyTagsToDataRepositoryAssociations.unwrap(value): java.lang.Boolean
        )
      )(_.copyTagsToDataRepositoryAssociations)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(lustreConfiguration.map(value => value.buildAwsValue()))(
        _.lustreConfiguration
      )
      .optionallyWith(
        dataRepositoryAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataRepositoryAssociations)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateFileCacheRequest.ReadOnly =
    zio.aws.fsx.model.CreateFileCacheRequest.wrap(buildAwsValue())
}
object CreateFileCacheRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateFileCacheRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateFileCacheRequest =
      zio.aws.fsx.model.CreateFileCacheRequest(
        clientRequestToken.map(value => value),
        fileCacheType,
        fileCacheTypeVersion,
        storageCapacity,
        subnetIds,
        securityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        copyTagsToDataRepositoryAssociations.map(value => value),
        kmsKeyId.map(value => value),
        lustreConfiguration.map(value => value.asEditable),
        dataRepositoryAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientRequestToken: Optional[ClientRequestToken]
    def fileCacheType: zio.aws.fsx.model.FileCacheType
    def fileCacheTypeVersion: FileSystemTypeVersion
    def storageCapacity: StorageCapacity
    def subnetIds: List[SubnetId]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def copyTagsToDataRepositoryAssociations
        : Optional[CopyTagsToDataRepositoryAssociations]
    def kmsKeyId: Optional[KmsKeyId]
    def lustreConfiguration: Optional[
      zio.aws.fsx.model.CreateFileCacheLustreConfiguration.ReadOnly
    ]
    def dataRepositoryAssociations: Optional[
      List[zio.aws.fsx.model.FileCacheDataRepositoryAssociation.ReadOnly]
    ]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getFileCacheType: ZIO[Any, Nothing, zio.aws.fsx.model.FileCacheType] =
      ZIO.succeed(fileCacheType)
    def getFileCacheTypeVersion: ZIO[Any, Nothing, FileSystemTypeVersion] =
      ZIO.succeed(fileCacheTypeVersion)
    def getStorageCapacity: ZIO[Any, Nothing, StorageCapacity] =
      ZIO.succeed(storageCapacity)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCopyTagsToDataRepositoryAssociations
        : ZIO[Any, AwsError, CopyTagsToDataRepositoryAssociations] =
      AwsError.unwrapOptionField(
        "copyTagsToDataRepositoryAssociations",
        copyTagsToDataRepositoryAssociations
      )
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLustreConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateFileCacheLustreConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("lustreConfiguration", lustreConfiguration)
    def getDataRepositoryAssociations: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.FileCacheDataRepositoryAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dataRepositoryAssociations",
      dataRepositoryAssociations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileCacheRequest
  ) extends zio.aws.fsx.model.CreateFileCacheRequest.ReadOnly {
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val fileCacheType: zio.aws.fsx.model.FileCacheType =
      zio.aws.fsx.model.FileCacheType.wrap(impl.fileCacheType())
    override val fileCacheTypeVersion: FileSystemTypeVersion =
      zio.aws.fsx.model.primitives
        .FileSystemTypeVersion(impl.fileCacheTypeVersion())
    override val storageCapacity: StorageCapacity =
      zio.aws.fsx.model.primitives.StorageCapacity(impl.storageCapacity())
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.fsx.model.primitives.SubnetId(item)
      }
      .toList
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Tag.wrap(item)
          }.toList
        )
    override val copyTagsToDataRepositoryAssociations
        : Optional[CopyTagsToDataRepositoryAssociations] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToDataRepositoryAssociations())
      .map(value =>
        zio.aws.fsx.model.primitives.CopyTagsToDataRepositoryAssociations(value)
      )
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.fsx.model.primitives.KmsKeyId(value))
    override val lustreConfiguration: Optional[
      zio.aws.fsx.model.CreateFileCacheLustreConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lustreConfiguration())
      .map(value =>
        zio.aws.fsx.model.CreateFileCacheLustreConfiguration.wrap(value)
      )
    override val dataRepositoryAssociations: Optional[
      List[zio.aws.fsx.model.FileCacheDataRepositoryAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataRepositoryAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.FileCacheDataRepositoryAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileCacheRequest
  ): zio.aws.fsx.model.CreateFileCacheRequest.ReadOnly = new Wrapper(impl)
}
