package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  AdminPassword,
  StorageVirtualMachineName,
  FileSystemId,
  ClientRequestToken
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateStorageVirtualMachineRequest(
    activeDirectoryConfiguration: Optional[
      zio.aws.fsx.model.CreateSvmActiveDirectoryConfiguration
    ] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    fileSystemId: FileSystemId,
    name: StorageVirtualMachineName,
    svmAdminPassword: Optional[AdminPassword] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent,
    rootVolumeSecurityStyle: Optional[
      zio.aws.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineRequest = {
    import CreateStorageVirtualMachineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineRequest
      .builder()
      .optionallyWith(
        activeDirectoryConfiguration.map(value => value.buildAwsValue())
      )(_.activeDirectoryConfiguration)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .name(StorageVirtualMachineName.unwrap(name): java.lang.String)
      .optionallyWith(
        svmAdminPassword.map(value =>
          AdminPassword.unwrap(value): java.lang.String
        )
      )(_.svmAdminPassword)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(rootVolumeSecurityStyle.map(value => value.unwrap))(
        _.rootVolumeSecurityStyle
      )
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.CreateStorageVirtualMachineRequest.ReadOnly =
    zio.aws.fsx.model.CreateStorageVirtualMachineRequest.wrap(buildAwsValue())
}
object CreateStorageVirtualMachineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateStorageVirtualMachineRequest =
      zio.aws.fsx.model.CreateStorageVirtualMachineRequest(
        activeDirectoryConfiguration.map(value => value.asEditable),
        clientRequestToken.map(value => value),
        fileSystemId,
        name,
        svmAdminPassword.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        rootVolumeSecurityStyle.map(value => value)
      )
    def activeDirectoryConfiguration: Optional[
      zio.aws.fsx.model.CreateSvmActiveDirectoryConfiguration.ReadOnly
    ]
    def clientRequestToken: Optional[ClientRequestToken]
    def fileSystemId: FileSystemId
    def name: StorageVirtualMachineName
    def svmAdminPassword: Optional[AdminPassword]
    def tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def rootVolumeSecurityStyle: Optional[
      zio.aws.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle
    ]
    def getActiveDirectoryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateSvmActiveDirectoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activeDirectoryConfiguration",
      activeDirectoryConfiguration
    )
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getName: ZIO[Any, Nothing, StorageVirtualMachineName] =
      ZIO.succeed(name)
    def getSvmAdminPassword: ZIO[Any, AwsError, AdminPassword] =
      AwsError.unwrapOptionField("svmAdminPassword", svmAdminPassword)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRootVolumeSecurityStyle: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle
    ] = AwsError.unwrapOptionField(
      "rootVolumeSecurityStyle",
      rootVolumeSecurityStyle
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineRequest
  ) extends zio.aws.fsx.model.CreateStorageVirtualMachineRequest.ReadOnly {
    override val activeDirectoryConfiguration: Optional[
      zio.aws.fsx.model.CreateSvmActiveDirectoryConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.activeDirectoryConfiguration())
      .map(value =>
        zio.aws.fsx.model.CreateSvmActiveDirectoryConfiguration.wrap(value)
      )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val fileSystemId: FileSystemId =
      zio.aws.fsx.model.primitives.FileSystemId(impl.fileSystemId())
    override val name: StorageVirtualMachineName =
      zio.aws.fsx.model.primitives.StorageVirtualMachineName(impl.name())
    override val svmAdminPassword: Optional[AdminPassword] =
      zio.aws.core.internal
        .optionalFromNullable(impl.svmAdminPassword())
        .map(value => zio.aws.fsx.model.primitives.AdminPassword(value))
    override val tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Tag.wrap(item)
          }.toList
        )
    override val rootVolumeSecurityStyle: Optional[
      zio.aws.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rootVolumeSecurityStyle())
      .map(value =>
        zio.aws.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineRequest
  ): zio.aws.fsx.model.CreateStorageVirtualMachineRequest.ReadOnly =
    new Wrapper(impl)
}
