package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateVolumeResponse(
    volume: Optional[zio.aws.fsx.model.Volume] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateVolumeResponse = {
    import CreateVolumeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateVolumeResponse
      .builder()
      .optionallyWith(volume.map(value => value.buildAwsValue()))(_.volume)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateVolumeResponse.ReadOnly =
    zio.aws.fsx.model.CreateVolumeResponse.wrap(buildAwsValue())
}
object CreateVolumeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateVolumeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateVolumeResponse = zio.aws.fsx.model
      .CreateVolumeResponse(volume.map(value => value.asEditable))
    def volume: Optional[zio.aws.fsx.model.Volume.ReadOnly]
    def getVolume: ZIO[Any, AwsError, zio.aws.fsx.model.Volume.ReadOnly] =
      AwsError.unwrapOptionField("volume", volume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateVolumeResponse
  ) extends zio.aws.fsx.model.CreateVolumeResponse.ReadOnly {
    override val volume: Optional[zio.aws.fsx.model.Volume.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volume())
        .map(value => zio.aws.fsx.model.Volume.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateVolumeResponse
  ): zio.aws.fsx.model.CreateVolumeResponse.ReadOnly = new Wrapper(impl)
}
