package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait DataRepositoryTaskType {
  def unwrap: software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType
}
object DataRepositoryTaskType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType
  ): zio.aws.fsx.model.DataRepositoryTaskType = value match {
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType.EXPORT_TO_REPOSITORY =>
      val r = EXPORT_TO_REPOSITORY
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType.IMPORT_METADATA_FROM_REPOSITORY =>
      val r = IMPORT_METADATA_FROM_REPOSITORY
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType.RELEASE_DATA_FROM_FILESYSTEM =>
      val r = RELEASE_DATA_FROM_FILESYSTEM
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType.AUTO_RELEASE_DATA =>
      val r = AUTO_RELEASE_DATA
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.DataRepositoryTaskType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType.UNKNOWN_TO_SDK_VERSION
  }
  case object EXPORT_TO_REPOSITORY
      extends zio.aws.fsx.model.DataRepositoryTaskType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType.EXPORT_TO_REPOSITORY
  }
  case object IMPORT_METADATA_FROM_REPOSITORY
      extends zio.aws.fsx.model.DataRepositoryTaskType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType.IMPORT_METADATA_FROM_REPOSITORY
  }
  case object RELEASE_DATA_FROM_FILESYSTEM
      extends zio.aws.fsx.model.DataRepositoryTaskType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType.RELEASE_DATA_FROM_FILESYSTEM
  }
  case object AUTO_RELEASE_DATA
      extends zio.aws.fsx.model.DataRepositoryTaskType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskType.AUTO_RELEASE_DATA
  }
}
