package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  WeeklyTime,
  LustreFileSystemMountName,
  PerUnitStorageThroughput
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class FileCacheLustreConfiguration(
    perUnitStorageThroughput: Optional[PerUnitStorageThroughput] =
      Optional.Absent,
    deploymentType: Optional[zio.aws.fsx.model.FileCacheLustreDeploymentType] =
      Optional.Absent,
    mountName: Optional[LustreFileSystemMountName] = Optional.Absent,
    weeklyMaintenanceStartTime: Optional[WeeklyTime] = Optional.Absent,
    metadataConfiguration: Optional[
      zio.aws.fsx.model.FileCacheLustreMetadataConfiguration
    ] = Optional.Absent,
    logConfiguration: Optional[zio.aws.fsx.model.LustreLogConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.FileCacheLustreConfiguration = {
    import FileCacheLustreConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.FileCacheLustreConfiguration
      .builder()
      .optionallyWith(
        perUnitStorageThroughput.map(value =>
          PerUnitStorageThroughput.unwrap(value): Integer
        )
      )(_.perUnitStorageThroughput)
      .optionallyWith(deploymentType.map(value => value.unwrap))(
        _.deploymentType
      )
      .optionallyWith(
        mountName.map(value =>
          LustreFileSystemMountName.unwrap(value): java.lang.String
        )
      )(_.mountName)
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        metadataConfiguration.map(value => value.buildAwsValue())
      )(_.metadataConfiguration)
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.FileCacheLustreConfiguration.ReadOnly =
    zio.aws.fsx.model.FileCacheLustreConfiguration.wrap(buildAwsValue())
}
object FileCacheLustreConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.FileCacheLustreConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.FileCacheLustreConfiguration =
      zio.aws.fsx.model.FileCacheLustreConfiguration(
        perUnitStorageThroughput.map(value => value),
        deploymentType.map(value => value),
        mountName.map(value => value),
        weeklyMaintenanceStartTime.map(value => value),
        metadataConfiguration.map(value => value.asEditable),
        logConfiguration.map(value => value.asEditable)
      )
    def perUnitStorageThroughput: Optional[PerUnitStorageThroughput]
    def deploymentType
        : Optional[zio.aws.fsx.model.FileCacheLustreDeploymentType]
    def mountName: Optional[LustreFileSystemMountName]
    def weeklyMaintenanceStartTime: Optional[WeeklyTime]
    def metadataConfiguration: Optional[
      zio.aws.fsx.model.FileCacheLustreMetadataConfiguration.ReadOnly
    ]
    def logConfiguration
        : Optional[zio.aws.fsx.model.LustreLogConfiguration.ReadOnly]
    def getPerUnitStorageThroughput
        : ZIO[Any, AwsError, PerUnitStorageThroughput] = AwsError
      .unwrapOptionField("perUnitStorageThroughput", perUnitStorageThroughput)
    def getDeploymentType
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileCacheLustreDeploymentType] =
      AwsError.unwrapOptionField("deploymentType", deploymentType)
    def getMountName: ZIO[Any, AwsError, LustreFileSystemMountName] =
      AwsError.unwrapOptionField("mountName", mountName)
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getMetadataConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.FileCacheLustreMetadataConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("metadataConfiguration", metadataConfiguration)
    def getLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.LustreLogConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("logConfiguration", logConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.FileCacheLustreConfiguration
  ) extends zio.aws.fsx.model.FileCacheLustreConfiguration.ReadOnly {
    override val perUnitStorageThroughput: Optional[PerUnitStorageThroughput] =
      zio.aws.core.internal
        .optionalFromNullable(impl.perUnitStorageThroughput())
        .map(value =>
          zio.aws.fsx.model.primitives.PerUnitStorageThroughput(value)
        )
    override val deploymentType
        : Optional[zio.aws.fsx.model.FileCacheLustreDeploymentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentType())
        .map(value =>
          zio.aws.fsx.model.FileCacheLustreDeploymentType.wrap(value)
        )
    override val mountName: Optional[LustreFileSystemMountName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mountName())
        .map(value =>
          zio.aws.fsx.model.primitives.LustreFileSystemMountName(value)
        )
    override val weeklyMaintenanceStartTime: Optional[WeeklyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weeklyMaintenanceStartTime())
        .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val metadataConfiguration: Optional[
      zio.aws.fsx.model.FileCacheLustreMetadataConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metadataConfiguration())
      .map(value =>
        zio.aws.fsx.model.FileCacheLustreMetadataConfiguration.wrap(value)
      )
    override val logConfiguration
        : Optional[zio.aws.fsx.model.LustreLogConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logConfiguration())
        .map(value => zio.aws.fsx.model.LustreLogConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.FileCacheLustreConfiguration
  ): zio.aws.fsx.model.FileCacheLustreConfiguration.ReadOnly = new Wrapper(impl)
}
