package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.fsx.model.primitives.MetadataStorageCapacity
import scala.jdk.CollectionConverters.*
final case class FileCacheLustreMetadataConfiguration(
    storageCapacity: MetadataStorageCapacity
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.FileCacheLustreMetadataConfiguration = {
    import FileCacheLustreMetadataConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.FileCacheLustreMetadataConfiguration
      .builder()
      .storageCapacity(MetadataStorageCapacity.unwrap(storageCapacity): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.FileCacheLustreMetadataConfiguration.ReadOnly =
    zio.aws.fsx.model.FileCacheLustreMetadataConfiguration.wrap(buildAwsValue())
}
object FileCacheLustreMetadataConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.FileCacheLustreMetadataConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.FileCacheLustreMetadataConfiguration =
      zio.aws.fsx.model.FileCacheLustreMetadataConfiguration(storageCapacity)
    def storageCapacity: MetadataStorageCapacity
    def getStorageCapacity: ZIO[Any, Nothing, MetadataStorageCapacity] =
      ZIO.succeed(storageCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.FileCacheLustreMetadataConfiguration
  ) extends zio.aws.fsx.model.FileCacheLustreMetadataConfiguration.ReadOnly {
    override val storageCapacity: MetadataStorageCapacity =
      zio.aws.fsx.model.primitives
        .MetadataStorageCapacity(impl.storageCapacity())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.FileCacheLustreMetadataConfiguration
  ): zio.aws.fsx.model.FileCacheLustreMetadataConfiguration.ReadOnly =
    new Wrapper(impl)
}
