package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait FileSystemLifecycle {
  def unwrap: software.amazon.awssdk.services.fsx.model.FileSystemLifecycle
}
object FileSystemLifecycle {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.FileSystemLifecycle
  ): zio.aws.fsx.model.FileSystemLifecycle = value match {
    case software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.MISCONFIGURED =>
      val r = MISCONFIGURED
      r
    case software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.MISCONFIGURED_UNAVAILABLE =>
      val r = MISCONFIGURED_UNAVAILABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.FileSystemLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemLifecycle =
      software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.fsx.model.FileSystemLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemLifecycle =
      software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.AVAILABLE
  }
  case object CREATING extends zio.aws.fsx.model.FileSystemLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemLifecycle =
      software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.CREATING
  }
  case object FAILED extends zio.aws.fsx.model.FileSystemLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemLifecycle =
      software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.FAILED
  }
  case object DELETING extends zio.aws.fsx.model.FileSystemLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemLifecycle =
      software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.DELETING
  }
  case object MISCONFIGURED extends zio.aws.fsx.model.FileSystemLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemLifecycle =
      software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.MISCONFIGURED
  }
  case object UPDATING extends zio.aws.fsx.model.FileSystemLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemLifecycle =
      software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.UPDATING
  }
  case object MISCONFIGURED_UNAVAILABLE
      extends zio.aws.fsx.model.FileSystemLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemLifecycle =
      software.amazon.awssdk.services.fsx.model.FileSystemLifecycle.MISCONFIGURED_UNAVAILABLE
  }
}
