package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait FileSystemType {
  def unwrap: software.amazon.awssdk.services.fsx.model.FileSystemType
}
object FileSystemType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.FileSystemType
  ): zio.aws.fsx.model.FileSystemType = value match {
    case software.amazon.awssdk.services.fsx.model.FileSystemType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.FileSystemType.WINDOWS =>
      val r = WINDOWS
      r
    case software.amazon.awssdk.services.fsx.model.FileSystemType.LUSTRE =>
      val r = LUSTRE
      r
    case software.amazon.awssdk.services.fsx.model.FileSystemType.ONTAP =>
      val r = ONTAP
      r
    case software.amazon.awssdk.services.fsx.model.FileSystemType.OPENZFS =>
      val r = OPENZFS
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.FileSystemType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemType =
      software.amazon.awssdk.services.fsx.model.FileSystemType.UNKNOWN_TO_SDK_VERSION
  }
  case object WINDOWS extends zio.aws.fsx.model.FileSystemType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemType =
      software.amazon.awssdk.services.fsx.model.FileSystemType.WINDOWS
  }
  case object LUSTRE extends zio.aws.fsx.model.FileSystemType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemType =
      software.amazon.awssdk.services.fsx.model.FileSystemType.LUSTRE
  }
  case object ONTAP extends zio.aws.fsx.model.FileSystemType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemType =
      software.amazon.awssdk.services.fsx.model.FileSystemType.ONTAP
  }
  case object OPENZFS extends zio.aws.fsx.model.FileSystemType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemType =
      software.amazon.awssdk.services.fsx.model.FileSystemType.OPENZFS
  }
}
