package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait FlexCacheEndpointType {
  def unwrap: software.amazon.awssdk.services.fsx.model.FlexCacheEndpointType
}
object FlexCacheEndpointType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.FlexCacheEndpointType
  ): zio.aws.fsx.model.FlexCacheEndpointType = value match {
    case software.amazon.awssdk.services.fsx.model.FlexCacheEndpointType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.FlexCacheEndpointType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.fsx.model.FlexCacheEndpointType.ORIGIN =>
      val r = ORIGIN
      r
    case software.amazon.awssdk.services.fsx.model.FlexCacheEndpointType.CACHE =>
      val r = CACHE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.FlexCacheEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FlexCacheEndpointType =
      software.amazon.awssdk.services.fsx.model.FlexCacheEndpointType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.fsx.model.FlexCacheEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FlexCacheEndpointType =
      software.amazon.awssdk.services.fsx.model.FlexCacheEndpointType.NONE
  }
  case object ORIGIN extends zio.aws.fsx.model.FlexCacheEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FlexCacheEndpointType =
      software.amazon.awssdk.services.fsx.model.FlexCacheEndpointType.ORIGIN
  }
  case object CACHE extends zio.aws.fsx.model.FlexCacheEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FlexCacheEndpointType =
      software.amazon.awssdk.services.fsx.model.FlexCacheEndpointType.CACHE
  }
}
