package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait LustreAccessAuditLogLevel {
  def unwrap
      : software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel
}
object LustreAccessAuditLogLevel {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel
  ): zio.aws.fsx.model.LustreAccessAuditLogLevel = value match {
    case software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel.WARN_ONLY =>
      val r = WARN_ONLY
      r
    case software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel.ERROR_ONLY =>
      val r = ERROR_ONLY
      r
    case software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel.WARN_ERROR =>
      val r = WARN_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.LustreAccessAuditLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel =
      software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.fsx.model.LustreAccessAuditLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel =
      software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel.DISABLED
  }
  case object WARN_ONLY extends zio.aws.fsx.model.LustreAccessAuditLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel =
      software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel.WARN_ONLY
  }
  case object ERROR_ONLY extends zio.aws.fsx.model.LustreAccessAuditLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel =
      software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel.ERROR_ONLY
  }
  case object WARN_ERROR extends zio.aws.fsx.model.LustreAccessAuditLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel =
      software.amazon.awssdk.services.fsx.model.LustreAccessAuditLogLevel.WARN_ERROR
  }
}
