package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{LustreNoSquashNid, LustreRootSquash}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LustreRootSquashConfiguration(
    rootSquash: Optional[LustreRootSquash] = Optional.Absent,
    noSquashNids: Optional[Iterable[LustreNoSquashNid]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.LustreRootSquashConfiguration = {
    import LustreRootSquashConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.LustreRootSquashConfiguration
      .builder()
      .optionallyWith(
        rootSquash.map(value =>
          LustreRootSquash.unwrap(value): java.lang.String
        )
      )(_.rootSquash)
      .optionallyWith(
        noSquashNids.map(value =>
          value.map { item =>
            LustreNoSquashNid.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.noSquashNids)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.LustreRootSquashConfiguration.ReadOnly =
    zio.aws.fsx.model.LustreRootSquashConfiguration.wrap(buildAwsValue())
}
object LustreRootSquashConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.LustreRootSquashConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.LustreRootSquashConfiguration =
      zio.aws.fsx.model.LustreRootSquashConfiguration(
        rootSquash.map(value => value),
        noSquashNids.map(value => value)
      )
    def rootSquash: Optional[LustreRootSquash]
    def noSquashNids: Optional[List[LustreNoSquashNid]]
    def getRootSquash: ZIO[Any, AwsError, LustreRootSquash] =
      AwsError.unwrapOptionField("rootSquash", rootSquash)
    def getNoSquashNids: ZIO[Any, AwsError, List[LustreNoSquashNid]] =
      AwsError.unwrapOptionField("noSquashNids", noSquashNids)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.LustreRootSquashConfiguration
  ) extends zio.aws.fsx.model.LustreRootSquashConfiguration.ReadOnly {
    override val rootSquash: Optional[LustreRootSquash] = zio.aws.core.internal
      .optionalFromNullable(impl.rootSquash())
      .map(value => zio.aws.fsx.model.primitives.LustreRootSquash(value))
    override val noSquashNids: Optional[List[LustreNoSquashNid]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noSquashNids())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.LustreNoSquashNid(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.LustreRootSquashConfiguration
  ): zio.aws.fsx.model.LustreRootSquashConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
