package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class OpenZFSNfsExport(
    clientConfigurations: Iterable[zio.aws.fsx.model.OpenZFSClientConfiguration]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.OpenZFSNfsExport = {
    import OpenZFSNfsExport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.OpenZFSNfsExport
      .builder()
      .clientConfigurations(clientConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly =
    zio.aws.fsx.model.OpenZFSNfsExport.wrap(buildAwsValue())
}
object OpenZFSNfsExport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.OpenZFSNfsExport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.OpenZFSNfsExport =
      zio.aws.fsx.model.OpenZFSNfsExport(clientConfigurations.map { item =>
        item.asEditable
      })
    def clientConfigurations
        : List[zio.aws.fsx.model.OpenZFSClientConfiguration.ReadOnly]
    def getClientConfigurations: ZIO[Any, Nothing, List[
      zio.aws.fsx.model.OpenZFSClientConfiguration.ReadOnly
    ]] = ZIO.succeed(clientConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.OpenZFSNfsExport
  ) extends zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly {
    override val clientConfigurations
        : List[zio.aws.fsx.model.OpenZFSClientConfiguration.ReadOnly] = impl
      .clientConfigurations()
      .asScala
      .map { item =>
        zio.aws.fsx.model.OpenZFSClientConfiguration.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.OpenZFSNfsExport
  ): zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly = new Wrapper(impl)
}
