package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.VolumeId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RestoreVolumeFromSnapshotResponse(
    volumeId: Optional[VolumeId] = Optional.Absent,
    lifecycle: Optional[zio.aws.fsx.model.VolumeLifecycle] = Optional.Absent,
    administrativeActions: Optional[
      Iterable[zio.aws.fsx.model.AdministrativeAction]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotResponse = {
    import RestoreVolumeFromSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotResponse
      .builder()
      .optionallyWith(
        volumeId.map(value => VolumeId.unwrap(value): java.lang.String)
      )(_.volumeId)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(
        administrativeActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.administrativeActions)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse.ReadOnly =
    zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse.wrap(buildAwsValue())
}
object RestoreVolumeFromSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse =
      zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse(
        volumeId.map(value => value),
        lifecycle.map(value => value),
        administrativeActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def volumeId: Optional[VolumeId]
    def lifecycle: Optional[zio.aws.fsx.model.VolumeLifecycle]
    def administrativeActions
        : Optional[List[zio.aws.fsx.model.AdministrativeAction.ReadOnly]]
    def getVolumeId: ZIO[Any, AwsError, VolumeId] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getLifecycle: ZIO[Any, AwsError, zio.aws.fsx.model.VolumeLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getAdministrativeActions: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.AdministrativeAction.ReadOnly
    ]] =
      AwsError.unwrapOptionField("administrativeActions", administrativeActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotResponse
  ) extends zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse.ReadOnly {
    override val volumeId: Optional[VolumeId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeId())
      .map(value => zio.aws.fsx.model.primitives.VolumeId(value))
    override val lifecycle: Optional[zio.aws.fsx.model.VolumeLifecycle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.fsx.model.VolumeLifecycle.wrap(value))
    override val administrativeActions
        : Optional[List[zio.aws.fsx.model.AdministrativeAction.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.administrativeActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.AdministrativeAction.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotResponse
  ): zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
