package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.WeeklyTime
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFileCacheLustreConfiguration(
    weeklyMaintenanceStartTime: Optional[WeeklyTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateFileCacheLustreConfiguration = {
    import UpdateFileCacheLustreConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateFileCacheLustreConfiguration
      .builder()
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.UpdateFileCacheLustreConfiguration.ReadOnly =
    zio.aws.fsx.model.UpdateFileCacheLustreConfiguration.wrap(buildAwsValue())
}
object UpdateFileCacheLustreConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateFileCacheLustreConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateFileCacheLustreConfiguration =
      zio.aws.fsx.model.UpdateFileCacheLustreConfiguration(
        weeklyMaintenanceStartTime.map(value => value)
      )
    def weeklyMaintenanceStartTime: Optional[WeeklyTime]
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileCacheLustreConfiguration
  ) extends zio.aws.fsx.model.UpdateFileCacheLustreConfiguration.ReadOnly {
    override val weeklyMaintenanceStartTime: Optional[WeeklyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weeklyMaintenanceStartTime())
        .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileCacheLustreConfiguration
  ): zio.aws.fsx.model.UpdateFileCacheLustreConfiguration.ReadOnly =
    new Wrapper(impl)
}
