package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFileCacheResponse(
    fileCache: Optional[zio.aws.fsx.model.FileCache] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateFileCacheResponse = {
    import UpdateFileCacheResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateFileCacheResponse
      .builder()
      .optionallyWith(fileCache.map(value => value.buildAwsValue()))(
        _.fileCache
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.UpdateFileCacheResponse.ReadOnly =
    zio.aws.fsx.model.UpdateFileCacheResponse.wrap(buildAwsValue())
}
object UpdateFileCacheResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateFileCacheResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateFileCacheResponse =
      zio.aws.fsx.model
        .UpdateFileCacheResponse(fileCache.map(value => value.asEditable))
    def fileCache: Optional[zio.aws.fsx.model.FileCache.ReadOnly]
    def getFileCache: ZIO[Any, AwsError, zio.aws.fsx.model.FileCache.ReadOnly] =
      AwsError.unwrapOptionField("fileCache", fileCache)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileCacheResponse
  ) extends zio.aws.fsx.model.UpdateFileCacheResponse.ReadOnly {
    override val fileCache: Optional[zio.aws.fsx.model.FileCache.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileCache())
        .map(value => zio.aws.fsx.model.FileCache.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileCacheResponse
  ): zio.aws.fsx.model.UpdateFileCacheResponse.ReadOnly = new Wrapper(impl)
}
