package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  AutomaticBackupRetentionDays,
  DailyTime,
  WeeklyTime
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateFileSystemLustreConfiguration(
    weeklyMaintenanceStartTime: Optional[WeeklyTime] = Optional.Absent,
    dailyAutomaticBackupStartTime: Optional[DailyTime] = Optional.Absent,
    automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays] =
      Optional.Absent,
    autoImportPolicy: Optional[zio.aws.fsx.model.AutoImportPolicyType] =
      Optional.Absent,
    dataCompressionType: Optional[zio.aws.fsx.model.DataCompressionType] =
      Optional.Absent,
    logConfiguration: Optional[zio.aws.fsx.model.LustreLogCreateConfiguration] =
      Optional.Absent,
    rootSquashConfiguration: Optional[
      zio.aws.fsx.model.LustreRootSquashConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateFileSystemLustreConfiguration = {
    import UpdateFileSystemLustreConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemLustreConfiguration
      .builder()
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(autoImportPolicy.map(value => value.unwrap))(
        _.autoImportPolicy
      )
      .optionallyWith(dataCompressionType.map(value => value.unwrap))(
        _.dataCompressionType
      )
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .optionallyWith(
        rootSquashConfiguration.map(value => value.buildAwsValue())
      )(_.rootSquashConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.UpdateFileSystemLustreConfiguration.ReadOnly =
    zio.aws.fsx.model.UpdateFileSystemLustreConfiguration.wrap(buildAwsValue())
}
object UpdateFileSystemLustreConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemLustreConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateFileSystemLustreConfiguration =
      zio.aws.fsx.model.UpdateFileSystemLustreConfiguration(
        weeklyMaintenanceStartTime.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        automaticBackupRetentionDays.map(value => value),
        autoImportPolicy.map(value => value),
        dataCompressionType.map(value => value),
        logConfiguration.map(value => value.asEditable),
        rootSquashConfiguration.map(value => value.asEditable)
      )
    def weeklyMaintenanceStartTime: Optional[WeeklyTime]
    def dailyAutomaticBackupStartTime: Optional[DailyTime]
    def automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays]
    def autoImportPolicy: Optional[zio.aws.fsx.model.AutoImportPolicyType]
    def dataCompressionType: Optional[zio.aws.fsx.model.DataCompressionType]
    def logConfiguration
        : Optional[zio.aws.fsx.model.LustreLogCreateConfiguration.ReadOnly]
    def rootSquashConfiguration
        : Optional[zio.aws.fsx.model.LustreRootSquashConfiguration.ReadOnly]
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getAutoImportPolicy
        : ZIO[Any, AwsError, zio.aws.fsx.model.AutoImportPolicyType] =
      AwsError.unwrapOptionField("autoImportPolicy", autoImportPolicy)
    def getDataCompressionType
        : ZIO[Any, AwsError, zio.aws.fsx.model.DataCompressionType] =
      AwsError.unwrapOptionField("dataCompressionType", dataCompressionType)
    def getLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.LustreLogCreateConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("logConfiguration", logConfiguration)
    def getRootSquashConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.LustreRootSquashConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rootSquashConfiguration",
      rootSquashConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemLustreConfiguration
  ) extends zio.aws.fsx.model.UpdateFileSystemLustreConfiguration.ReadOnly {
    override val weeklyMaintenanceStartTime: Optional[WeeklyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weeklyMaintenanceStartTime())
        .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val dailyAutomaticBackupStartTime: Optional[DailyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dailyAutomaticBackupStartTime())
        .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val automaticBackupRetentionDays
        : Optional[AutomaticBackupRetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val autoImportPolicy
        : Optional[zio.aws.fsx.model.AutoImportPolicyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoImportPolicy())
        .map(value => zio.aws.fsx.model.AutoImportPolicyType.wrap(value))
    override val dataCompressionType
        : Optional[zio.aws.fsx.model.DataCompressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCompressionType())
        .map(value => zio.aws.fsx.model.DataCompressionType.wrap(value))
    override val logConfiguration
        : Optional[zio.aws.fsx.model.LustreLogCreateConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logConfiguration())
        .map(value =>
          zio.aws.fsx.model.LustreLogCreateConfiguration.wrap(value)
        )
    override val rootSquashConfiguration
        : Optional[zio.aws.fsx.model.LustreRootSquashConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootSquashConfiguration())
        .map(value =>
          zio.aws.fsx.model.LustreRootSquashConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemLustreConfiguration
  ): zio.aws.fsx.model.UpdateFileSystemLustreConfiguration.ReadOnly =
    new Wrapper(impl)
}
