package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  StorageCapacity,
  ClientRequestToken,
  FileSystemId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateFileSystemRequest(
    fileSystemId: FileSystemId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    storageCapacity: Optional[StorageCapacity] = Optional.Absent,
    windowsConfiguration: Optional[
      zio.aws.fsx.model.UpdateFileSystemWindowsConfiguration
    ] = Optional.Absent,
    lustreConfiguration: Optional[
      zio.aws.fsx.model.UpdateFileSystemLustreConfiguration
    ] = Optional.Absent,
    ontapConfiguration: Optional[
      zio.aws.fsx.model.UpdateFileSystemOntapConfiguration
    ] = Optional.Absent,
    openZFSConfiguration: Optional[
      zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateFileSystemRequest = {
    import UpdateFileSystemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemRequest
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        storageCapacity.map(value => StorageCapacity.unwrap(value): Integer)
      )(_.storageCapacity)
      .optionallyWith(windowsConfiguration.map(value => value.buildAwsValue()))(
        _.windowsConfiguration
      )
      .optionallyWith(lustreConfiguration.map(value => value.buildAwsValue()))(
        _.lustreConfiguration
      )
      .optionallyWith(ontapConfiguration.map(value => value.buildAwsValue()))(
        _.ontapConfiguration
      )
      .optionallyWith(openZFSConfiguration.map(value => value.buildAwsValue()))(
        _.openZFSConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.UpdateFileSystemRequest.ReadOnly =
    zio.aws.fsx.model.UpdateFileSystemRequest.wrap(buildAwsValue())
}
object UpdateFileSystemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateFileSystemRequest =
      zio.aws.fsx.model.UpdateFileSystemRequest(
        fileSystemId,
        clientRequestToken.map(value => value),
        storageCapacity.map(value => value),
        windowsConfiguration.map(value => value.asEditable),
        lustreConfiguration.map(value => value.asEditable),
        ontapConfiguration.map(value => value.asEditable),
        openZFSConfiguration.map(value => value.asEditable)
      )
    def fileSystemId: FileSystemId
    def clientRequestToken: Optional[ClientRequestToken]
    def storageCapacity: Optional[StorageCapacity]
    def windowsConfiguration: Optional[
      zio.aws.fsx.model.UpdateFileSystemWindowsConfiguration.ReadOnly
    ]
    def lustreConfiguration: Optional[
      zio.aws.fsx.model.UpdateFileSystemLustreConfiguration.ReadOnly
    ]
    def ontapConfiguration: Optional[
      zio.aws.fsx.model.UpdateFileSystemOntapConfiguration.ReadOnly
    ]
    def openZFSConfiguration: Optional[
      zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration.ReadOnly
    ]
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getStorageCapacity: ZIO[Any, AwsError, StorageCapacity] =
      AwsError.unwrapOptionField("storageCapacity", storageCapacity)
    def getWindowsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.UpdateFileSystemWindowsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("windowsConfiguration", windowsConfiguration)
    def getLustreConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.UpdateFileSystemLustreConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("lustreConfiguration", lustreConfiguration)
    def getOntapConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.UpdateFileSystemOntapConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ontapConfiguration", ontapConfiguration)
    def getOpenZFSConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("openZFSConfiguration", openZFSConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemRequest
  ) extends zio.aws.fsx.model.UpdateFileSystemRequest.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.fsx.model.primitives.FileSystemId(impl.fileSystemId())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val storageCapacity: Optional[StorageCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageCapacity())
        .map(value => zio.aws.fsx.model.primitives.StorageCapacity(value))
    override val windowsConfiguration: Optional[
      zio.aws.fsx.model.UpdateFileSystemWindowsConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.windowsConfiguration())
      .map(value =>
        zio.aws.fsx.model.UpdateFileSystemWindowsConfiguration.wrap(value)
      )
    override val lustreConfiguration: Optional[
      zio.aws.fsx.model.UpdateFileSystemLustreConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lustreConfiguration())
      .map(value =>
        zio.aws.fsx.model.UpdateFileSystemLustreConfiguration.wrap(value)
      )
    override val ontapConfiguration: Optional[
      zio.aws.fsx.model.UpdateFileSystemOntapConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ontapConfiguration())
      .map(value =>
        zio.aws.fsx.model.UpdateFileSystemOntapConfiguration.wrap(value)
      )
    override val openZFSConfiguration: Optional[
      zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.openZFSConfiguration())
      .map(value =>
        zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemRequest
  ): zio.aws.fsx.model.UpdateFileSystemRequest.ReadOnly = new Wrapper(impl)
}
