package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  SnapshotPolicy,
  Flag,
  VolumeCapacity,
  JunctionPath
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateOntapVolumeConfiguration(
    junctionPath: Optional[JunctionPath] = Optional.Absent,
    securityStyle: Optional[zio.aws.fsx.model.SecurityStyle] = Optional.Absent,
    sizeInMegabytes: Optional[VolumeCapacity] = Optional.Absent,
    storageEfficiencyEnabled: Optional[Flag] = Optional.Absent,
    tieringPolicy: Optional[zio.aws.fsx.model.TieringPolicy] = Optional.Absent,
    snapshotPolicy: Optional[SnapshotPolicy] = Optional.Absent,
    copyTagsToBackups: Optional[Flag] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateOntapVolumeConfiguration = {
    import UpdateOntapVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateOntapVolumeConfiguration
      .builder()
      .optionallyWith(
        junctionPath.map(value => JunctionPath.unwrap(value): java.lang.String)
      )(_.junctionPath)
      .optionallyWith(securityStyle.map(value => value.unwrap))(_.securityStyle)
      .optionallyWith(
        sizeInMegabytes.map(value => VolumeCapacity.unwrap(value): Integer)
      )(_.sizeInMegabytes)
      .optionallyWith(
        storageEfficiencyEnabled.map(value =>
          Flag.unwrap(value): java.lang.Boolean
        )
      )(_.storageEfficiencyEnabled)
      .optionallyWith(tieringPolicy.map(value => value.buildAwsValue()))(
        _.tieringPolicy
      )
      .optionallyWith(
        snapshotPolicy.map(value =>
          SnapshotPolicy.unwrap(value): java.lang.String
        )
      )(_.snapshotPolicy)
      .optionallyWith(
        copyTagsToBackups.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToBackups)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.UpdateOntapVolumeConfiguration.ReadOnly =
    zio.aws.fsx.model.UpdateOntapVolumeConfiguration.wrap(buildAwsValue())
}
object UpdateOntapVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateOntapVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateOntapVolumeConfiguration =
      zio.aws.fsx.model.UpdateOntapVolumeConfiguration(
        junctionPath.map(value => value),
        securityStyle.map(value => value),
        sizeInMegabytes.map(value => value),
        storageEfficiencyEnabled.map(value => value),
        tieringPolicy.map(value => value.asEditable),
        snapshotPolicy.map(value => value),
        copyTagsToBackups.map(value => value)
      )
    def junctionPath: Optional[JunctionPath]
    def securityStyle: Optional[zio.aws.fsx.model.SecurityStyle]
    def sizeInMegabytes: Optional[VolumeCapacity]
    def storageEfficiencyEnabled: Optional[Flag]
    def tieringPolicy: Optional[zio.aws.fsx.model.TieringPolicy.ReadOnly]
    def snapshotPolicy: Optional[SnapshotPolicy]
    def copyTagsToBackups: Optional[Flag]
    def getJunctionPath: ZIO[Any, AwsError, JunctionPath] =
      AwsError.unwrapOptionField("junctionPath", junctionPath)
    def getSecurityStyle: ZIO[Any, AwsError, zio.aws.fsx.model.SecurityStyle] =
      AwsError.unwrapOptionField("securityStyle", securityStyle)
    def getSizeInMegabytes: ZIO[Any, AwsError, VolumeCapacity] =
      AwsError.unwrapOptionField("sizeInMegabytes", sizeInMegabytes)
    def getStorageEfficiencyEnabled: ZIO[Any, AwsError, Flag] = AwsError
      .unwrapOptionField("storageEfficiencyEnabled", storageEfficiencyEnabled)
    def getTieringPolicy
        : ZIO[Any, AwsError, zio.aws.fsx.model.TieringPolicy.ReadOnly] =
      AwsError.unwrapOptionField("tieringPolicy", tieringPolicy)
    def getSnapshotPolicy: ZIO[Any, AwsError, SnapshotPolicy] =
      AwsError.unwrapOptionField("snapshotPolicy", snapshotPolicy)
    def getCopyTagsToBackups: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToBackups", copyTagsToBackups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateOntapVolumeConfiguration
  ) extends zio.aws.fsx.model.UpdateOntapVolumeConfiguration.ReadOnly {
    override val junctionPath: Optional[JunctionPath] = zio.aws.core.internal
      .optionalFromNullable(impl.junctionPath())
      .map(value => zio.aws.fsx.model.primitives.JunctionPath(value))
    override val securityStyle: Optional[zio.aws.fsx.model.SecurityStyle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityStyle())
        .map(value => zio.aws.fsx.model.SecurityStyle.wrap(value))
    override val sizeInMegabytes: Optional[VolumeCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeInMegabytes())
        .map(value => zio.aws.fsx.model.primitives.VolumeCapacity(value))
    override val storageEfficiencyEnabled: Optional[Flag] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageEfficiencyEnabled())
        .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val tieringPolicy
        : Optional[zio.aws.fsx.model.TieringPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tieringPolicy())
        .map(value => zio.aws.fsx.model.TieringPolicy.wrap(value))
    override val snapshotPolicy: Optional[SnapshotPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotPolicy())
        .map(value => zio.aws.fsx.model.primitives.SnapshotPolicy(value))
    override val copyTagsToBackups: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToBackups())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateOntapVolumeConfiguration
  ): zio.aws.fsx.model.UpdateOntapVolumeConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
