package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  IntegerRecordSizeKiB,
  IntegerNoMaxFromNegativeOne
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateOpenZFSVolumeConfiguration(
    storageCapacityReservationGiB: Optional[IntegerNoMaxFromNegativeOne] =
      Optional.Absent,
    storageCapacityQuotaGiB: Optional[IntegerNoMaxFromNegativeOne] =
      Optional.Absent,
    recordSizeKiB: Optional[IntegerRecordSizeKiB] = Optional.Absent,
    dataCompressionType: Optional[
      zio.aws.fsx.model.OpenZFSDataCompressionType
    ] = Optional.Absent,
    nfsExports: Optional[Iterable[zio.aws.fsx.model.OpenZFSNfsExport]] =
      Optional.Absent,
    userAndGroupQuotas: Optional[
      Iterable[zio.aws.fsx.model.OpenZFSUserOrGroupQuota]
    ] = Optional.Absent,
    readOnly: Optional[zio.aws.fsx.model.primitives.ReadOnly] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateOpenZFSVolumeConfiguration = {
    import UpdateOpenZFSVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateOpenZFSVolumeConfiguration
      .builder()
      .optionallyWith(
        storageCapacityReservationGiB.map(value =>
          IntegerNoMaxFromNegativeOne.unwrap(value): Integer
        )
      )(_.storageCapacityReservationGiB)
      .optionallyWith(
        storageCapacityQuotaGiB.map(value =>
          IntegerNoMaxFromNegativeOne.unwrap(value): Integer
        )
      )(_.storageCapacityQuotaGiB)
      .optionallyWith(
        recordSizeKiB.map(value => IntegerRecordSizeKiB.unwrap(value): Integer)
      )(_.recordSizeKiB)
      .optionallyWith(dataCompressionType.map(value => value.unwrap))(
        _.dataCompressionType
      )
      .optionallyWith(
        nfsExports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nfsExports)
      .optionallyWith(
        userAndGroupQuotas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userAndGroupQuotas)
      .optionallyWith(
        readOnly.map(value =>
          zio.aws.fsx.model.primitives.ReadOnly.unwrap(value): java.lang.Boolean
        )
      )(_.readOnly)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration.ReadOnly =
    zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration.wrap(buildAwsValue())
}
object UpdateOpenZFSVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateOpenZFSVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration =
      zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration(
        storageCapacityReservationGiB.map(value => value),
        storageCapacityQuotaGiB.map(value => value),
        recordSizeKiB.map(value => value),
        dataCompressionType.map(value => value),
        nfsExports.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userAndGroupQuotas.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        readOnly.map(value => value)
      )
    def storageCapacityReservationGiB: Optional[IntegerNoMaxFromNegativeOne]
    def storageCapacityQuotaGiB: Optional[IntegerNoMaxFromNegativeOne]
    def recordSizeKiB: Optional[IntegerRecordSizeKiB]
    def dataCompressionType
        : Optional[zio.aws.fsx.model.OpenZFSDataCompressionType]
    def nfsExports: Optional[List[zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly]]
    def userAndGroupQuotas
        : Optional[List[zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly]]
    def readOnly: Optional[zio.aws.fsx.model.primitives.ReadOnly]
    def getStorageCapacityReservationGiB
        : ZIO[Any, AwsError, IntegerNoMaxFromNegativeOne] =
      AwsError.unwrapOptionField(
        "storageCapacityReservationGiB",
        storageCapacityReservationGiB
      )
    def getStorageCapacityQuotaGiB
        : ZIO[Any, AwsError, IntegerNoMaxFromNegativeOne] = AwsError
      .unwrapOptionField("storageCapacityQuotaGiB", storageCapacityQuotaGiB)
    def getRecordSizeKiB: ZIO[Any, AwsError, IntegerRecordSizeKiB] =
      AwsError.unwrapOptionField("recordSizeKiB", recordSizeKiB)
    def getDataCompressionType
        : ZIO[Any, AwsError, zio.aws.fsx.model.OpenZFSDataCompressionType] =
      AwsError.unwrapOptionField("dataCompressionType", dataCompressionType)
    def getNfsExports: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly
    ]] = AwsError.unwrapOptionField("nfsExports", nfsExports)
    def getUserAndGroupQuotas: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly
    ]] = AwsError.unwrapOptionField("userAndGroupQuotas", userAndGroupQuotas)
    def getReadOnly: ZIO[Any, AwsError, zio.aws.fsx.model.primitives.ReadOnly] =
      AwsError.unwrapOptionField("readOnly", readOnly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateOpenZFSVolumeConfiguration
  ) extends zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration.ReadOnly {
    override val storageCapacityReservationGiB
        : Optional[IntegerNoMaxFromNegativeOne] = zio.aws.core.internal
      .optionalFromNullable(impl.storageCapacityReservationGiB())
      .map(value =>
        zio.aws.fsx.model.primitives.IntegerNoMaxFromNegativeOne(value)
      )
    override val storageCapacityQuotaGiB
        : Optional[IntegerNoMaxFromNegativeOne] = zio.aws.core.internal
      .optionalFromNullable(impl.storageCapacityQuotaGiB())
      .map(value =>
        zio.aws.fsx.model.primitives.IntegerNoMaxFromNegativeOne(value)
      )
    override val recordSizeKiB: Optional[IntegerRecordSizeKiB] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordSizeKiB())
        .map(value => zio.aws.fsx.model.primitives.IntegerRecordSizeKiB(value))
    override val dataCompressionType
        : Optional[zio.aws.fsx.model.OpenZFSDataCompressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCompressionType())
        .map(value => zio.aws.fsx.model.OpenZFSDataCompressionType.wrap(value))
    override val nfsExports
        : Optional[List[zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nfsExports())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.OpenZFSNfsExport.wrap(item)
          }.toList
        )
    override val userAndGroupQuotas
        : Optional[List[zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userAndGroupQuotas())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.OpenZFSUserOrGroupQuota.wrap(item)
          }.toList
        )
    override val readOnly: Optional[zio.aws.fsx.model.primitives.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readOnly())
        .map(value => zio.aws.fsx.model.primitives.ReadOnly(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateOpenZFSVolumeConfiguration
  ): zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
