package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  AdminPassword,
  StorageVirtualMachineId,
  ClientRequestToken
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateStorageVirtualMachineRequest(
    activeDirectoryConfiguration: Optional[
      zio.aws.fsx.model.UpdateSvmActiveDirectoryConfiguration
    ] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    storageVirtualMachineId: StorageVirtualMachineId,
    svmAdminPassword: Optional[AdminPassword] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineRequest = {
    import UpdateStorageVirtualMachineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineRequest
      .builder()
      .optionallyWith(
        activeDirectoryConfiguration.map(value => value.buildAwsValue())
      )(_.activeDirectoryConfiguration)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .storageVirtualMachineId(
        StorageVirtualMachineId.unwrap(
          storageVirtualMachineId
        ): java.lang.String
      )
      .optionallyWith(
        svmAdminPassword.map(value =>
          AdminPassword.unwrap(value): java.lang.String
        )
      )(_.svmAdminPassword)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.UpdateStorageVirtualMachineRequest.ReadOnly =
    zio.aws.fsx.model.UpdateStorageVirtualMachineRequest.wrap(buildAwsValue())
}
object UpdateStorageVirtualMachineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateStorageVirtualMachineRequest =
      zio.aws.fsx.model.UpdateStorageVirtualMachineRequest(
        activeDirectoryConfiguration.map(value => value.asEditable),
        clientRequestToken.map(value => value),
        storageVirtualMachineId,
        svmAdminPassword.map(value => value)
      )
    def activeDirectoryConfiguration: Optional[
      zio.aws.fsx.model.UpdateSvmActiveDirectoryConfiguration.ReadOnly
    ]
    def clientRequestToken: Optional[ClientRequestToken]
    def storageVirtualMachineId: StorageVirtualMachineId
    def svmAdminPassword: Optional[AdminPassword]
    def getActiveDirectoryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.UpdateSvmActiveDirectoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activeDirectoryConfiguration",
      activeDirectoryConfiguration
    )
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getStorageVirtualMachineId: ZIO[Any, Nothing, StorageVirtualMachineId] =
      ZIO.succeed(storageVirtualMachineId)
    def getSvmAdminPassword: ZIO[Any, AwsError, AdminPassword] =
      AwsError.unwrapOptionField("svmAdminPassword", svmAdminPassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineRequest
  ) extends zio.aws.fsx.model.UpdateStorageVirtualMachineRequest.ReadOnly {
    override val activeDirectoryConfiguration: Optional[
      zio.aws.fsx.model.UpdateSvmActiveDirectoryConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.activeDirectoryConfiguration())
      .map(value =>
        zio.aws.fsx.model.UpdateSvmActiveDirectoryConfiguration.wrap(value)
      )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val storageVirtualMachineId: StorageVirtualMachineId =
      zio.aws.fsx.model.primitives
        .StorageVirtualMachineId(impl.storageVirtualMachineId())
    override val svmAdminPassword: Optional[AdminPassword] =
      zio.aws.core.internal
        .optionalFromNullable(impl.svmAdminPassword())
        .map(value => zio.aws.fsx.model.primitives.AdminPassword(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineRequest
  ): zio.aws.fsx.model.UpdateStorageVirtualMachineRequest.ReadOnly =
    new Wrapper(impl)
}
