package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait VolumeType {
  def unwrap: software.amazon.awssdk.services.fsx.model.VolumeType
}
object VolumeType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.VolumeType
  ): zio.aws.fsx.model.VolumeType = value match {
    case software.amazon.awssdk.services.fsx.model.VolumeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.VolumeType.ONTAP =>
      val r = ONTAP
      r
    case software.amazon.awssdk.services.fsx.model.VolumeType.OPENZFS =>
      val r = OPENZFS
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.VolumeType {
    override def unwrap: software.amazon.awssdk.services.fsx.model.VolumeType =
      software.amazon.awssdk.services.fsx.model.VolumeType.UNKNOWN_TO_SDK_VERSION
  }
  case object ONTAP extends zio.aws.fsx.model.VolumeType {
    override def unwrap: software.amazon.awssdk.services.fsx.model.VolumeType =
      software.amazon.awssdk.services.fsx.model.VolumeType.ONTAP
  }
  case object OPENZFS extends zio.aws.fsx.model.VolumeType {
    override def unwrap: software.amazon.awssdk.services.fsx.model.VolumeType =
      software.amazon.awssdk.services.fsx.model.VolumeType.OPENZFS
  }
}
