package zio.aws.gamelift
import zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly
import software.amazon.awssdk.services.gamelift.model.{
  ListBuildsResponse,
  DeleteGameSessionQueueRequest,
  ListGameServersRequest,
  DescribeGameServerInstancesResponse,
  UpdateAliasResponse,
  DescribeRuntimeConfigurationResponse,
  ClaimGameServerRequest,
  CreateScriptResponse,
  ListScriptsResponse,
  ListFleetsRequest,
  FleetCapacity,
  DescribeVpcPeeringAuthorizationsRequest,
  UpdateRuntimeConfigurationResponse,
  CreateMatchmakingConfigurationResponse,
  DescribeGameSessionPlacementRequest,
  CreateBuildResponse,
  UpdateScriptResponse,
  PutScalingPolicyResponse,
  ListGameServerGroupsResponse,
  ListLocationsResponse,
  DescribeScriptResponse,
  ListScriptsRequest,
  DescribeComputeResponse,
  CreateScriptRequest,
  DescribeScalingPoliciesResponse,
  GameSessionDetail,
  RegisterComputeResponse,
  CreatePlayerSessionResponse,
  UpdateFleetPortSettingsResponse,
  DescribeMatchmakingRuleSetsRequest,
  DescribeInstancesResponse,
  LocationAttributes,
  DescribeFleetLocationAttributesRequest,
  DeleteVpcPeeringAuthorizationResponse,
  CreateFleetResponse,
  Instance,
  AcceptMatchRequest,
  SuspendGameServerGroupResponse,
  DescribeFleetLocationUtilizationResponse,
  MatchmakingConfiguration,
  GetGameSessionLogUrlResponse,
  ValidateMatchmakingRuleSetRequest,
  GetComputeAccessRequest,
  DescribeMatchmakingRuleSetsResponse,
  DescribeGameSessionQueuesResponse,
  DescribeGameServerGroupResponse,
  DescribeGameSessionDetailsRequest,
  CreateFleetLocationsResponse,
  DescribeBuildResponse,
  UpdateFleetCapacityRequest,
  UpdateAliasRequest,
  DeleteFleetResponse,
  DescribeGameServerResponse,
  ResumeGameServerGroupRequest,
  ValidateMatchmakingRuleSetResponse,
  UpdateGameSessionRequest,
  GameSession,
  DeleteLocationResponse,
  DeleteGameServerGroupRequest,
  DescribeComputeRequest,
  CreatePlayerSessionsResponse,
  RegisterComputeRequest,
  CreateGameServerGroupRequest,
  DescribeBuildRequest,
  DescribeFleetEventsRequest,
  DescribeFleetPortSettingsRequest,
  PlayerSession,
  StopGameSessionPlacementRequest,
  RegisterGameServerRequest,
  StopFleetActionsResponse,
  DeleteAliasResponse,
  UpdateGameSessionQueueRequest,
  DescribeGameServerRequest,
  DescribeGameServerInstancesRequest,
  SuspendGameServerGroupRequest,
  StartMatchBackfillResponse,
  UpdateGameServerRequest,
  CreateAliasRequest,
  DeleteBuildRequest,
  DeleteMatchmakingConfigurationRequest,
  DescribeGameSessionsRequest,
  DescribeFleetAttributesResponse,
  DescribePlayerSessionsResponse,
  UpdateGameSessionQueueResponse,
  ListFleetsResponse,
  DeleteFleetLocationsResponse,
  ListComputeRequest,
  DescribeMatchmakingRequest,
  ListTagsForResourceRequest,
  UpdateRuntimeConfigurationRequest,
  RequestUploadCredentialsRequest,
  DeleteAliasRequest,
  GameServerGroup,
  StartFleetActionsResponse,
  CreateAliasResponse,
  ListAliasesRequest,
  CreateGameSessionResponse,
  CreateGameSessionRequest,
  CreateMatchmakingConfigurationRequest,
  ListBuildsRequest,
  GetGameSessionLogUrlRequest,
  UpdateGameServerGroupRequest,
  CreateVpcPeeringAuthorizationResponse,
  StartGameSessionPlacementResponse,
  GameServerInstance,
  ListLocationsRequest,
  Script,
  ListGameServerGroupsRequest,
  DescribeAliasResponse,
  DeleteScalingPolicyRequest,
  DescribeFleetUtilizationResponse,
  UpdateFleetAttributesRequest,
  DescribeFleetLocationCapacityResponse,
  PutScalingPolicyRequest,
  ListTagsForResourceResponse,
  UpdateBuildRequest,
  UntagResourceResponse,
  DescribeFleetAttributesRequest,
  DeregisterGameServerRequest,
  UpdateGameServerGroupResponse,
  ResolveAliasRequest,
  SearchGameSessionsResponse,
  DescribeGameSessionDetailsResponse,
  MatchmakingRuleSet,
  DeleteVpcPeeringAuthorizationRequest,
  ClaimGameServerResponse,
  UpdateFleetAttributesResponse,
  DescribePlayerSessionsRequest,
  UpdateMatchmakingConfigurationResponse,
  DeregisterComputeResponse,
  ResolveAliasResponse,
  DescribeVpcPeeringConnectionsRequest,
  StartMatchmakingResponse,
  ScalingPolicy,
  DescribeFleetCapacityRequest,
  CreatePlayerSessionRequest,
  CreateVpcPeeringConnectionRequest,
  SearchGameSessionsRequest,
  StopMatchmakingRequest,
  DescribeScriptRequest,
  CreateMatchmakingRuleSetResponse,
  DescribeAliasRequest,
  DeleteScalingPolicyResponse,
  DeleteGameServerGroupResponse,
  DescribeVpcPeeringConnectionsResponse,
  CreateFleetRequest,
  StopFleetActionsRequest,
  DescribeVpcPeeringAuthorizationsResponse,
  DeleteMatchmakingRuleSetRequest,
  DeleteMatchmakingRuleSetResponse,
  DescribeGameSessionPlacementResponse,
  DescribeMatchmakingConfigurationsRequest,
  UpdateBuildResponse,
  CreatePlayerSessionsRequest,
  DescribeMatchmakingResponse,
  DescribeFleetLocationCapacityRequest,
  CreateBuildRequest,
  DeleteScriptResponse,
  StartGameSessionPlacementRequest,
  GameServer,
  UntagResourceRequest,
  ResumeGameServerGroupResponse,
  GetComputeAuthTokenRequest,
  DeleteBuildResponse,
  FleetUtilization,
  DescribeFleetCapacityResponse,
  DescribeFleetLocationAttributesResponse,
  DeleteGameSessionQueueResponse,
  DeregisterComputeRequest,
  GetInstanceAccessResponse,
  DeleteMatchmakingConfigurationResponse,
  DescribeFleetLocationUtilizationRequest,
  DescribeGameServerGroupRequest,
  DescribeGameSessionsResponse,
  DescribeInstancesRequest,
  DescribeFleetEventsResponse,
  DescribeMatchmakingConfigurationsResponse,
  FleetAttributes,
  RequestUploadCredentialsResponse,
  Event,
  DescribeGameSessionQueuesRequest,
  UpdateMatchmakingConfigurationRequest,
  ListComputeResponse,
  Build,
  CreateGameSessionQueueResponse,
  ListAliasesResponse,
  UpdateScriptRequest,
  CreateLocationRequest,
  CreateGameSessionQueueRequest,
  GetComputeAuthTokenResponse,
  AcceptMatchResponse,
  DeleteLocationRequest,
  UpdateGameSessionResponse,
  UpdateGameServerResponse,
  DescribeFleetPortSettingsResponse,
  RegisterGameServerResponse,
  StartMatchmakingRequest,
  CreateMatchmakingRuleSetRequest,
  DescribeEc2InstanceLimitsResponse,
  CreateVpcPeeringConnectionResponse,
  TagResourceResponse,
  DeregisterGameServerResponse,
  UpdateFleetPortSettingsRequest,
  StopGameSessionPlacementResponse,
  DeleteVpcPeeringConnectionRequest,
  CreateLocationResponse,
  StartMatchBackfillRequest,
  CreateVpcPeeringAuthorizationRequest,
  DeleteVpcPeeringConnectionResponse,
  StartFleetActionsRequest,
  ListGameServersResponse,
  Compute,
  GetComputeAccessResponse,
  DescribeFleetUtilizationRequest,
  LocationModel,
  TagResourceRequest,
  DescribeRuntimeConfigurationRequest,
  Alias,
  DeleteFleetRequest,
  DeleteScriptRequest,
  DescribeScalingPoliciesRequest,
  CreateGameServerGroupResponse,
  StopMatchmakingResponse,
  GetInstanceAccessRequest,
  GameSessionQueue,
  DeleteFleetLocationsRequest,
  UpdateFleetCapacityResponse,
  CreateFleetLocationsRequest,
  DescribeEc2InstanceLimitsRequest
}
import zio.aws.core.config.AwsConfig
import zio.aws.gamelift.model.primitives.FleetId
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.gamelift.{
  GameLiftAsyncClientBuilder,
  GameLiftAsyncClient
}
import scala.jdk.CollectionConverters._
trait GameLift extends AspectSupport[GameLift] {
  val api: GameLiftAsyncClient
  def deleteBuild(
      request: zio.aws.gamelift.model.DeleteBuildRequest
  ): IO[AwsError, Unit]
  def describeVpcPeeringConnections(
      request: zio.aws.gamelift.model.DescribeVpcPeeringConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeVpcPeeringConnectionsResponse.ReadOnly
  ]
  def startMatchmaking(
      request: zio.aws.gamelift.model.StartMatchmakingRequest
  ): IO[AwsError, zio.aws.gamelift.model.StartMatchmakingResponse.ReadOnly]
  def updateGameServer(
      request: zio.aws.gamelift.model.UpdateGameServerRequest
  ): IO[AwsError, zio.aws.gamelift.model.UpdateGameServerResponse.ReadOnly]
  def getComputeAuthToken(
      request: zio.aws.gamelift.model.GetComputeAuthTokenRequest
  ): IO[AwsError, zio.aws.gamelift.model.GetComputeAuthTokenResponse.ReadOnly]
  def updateFleetPortSettings(
      request: zio.aws.gamelift.model.UpdateFleetPortSettingsRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.UpdateFleetPortSettingsResponse.ReadOnly
  ]
  def describeMatchmaking(
      request: zio.aws.gamelift.model.DescribeMatchmakingRequest
  ): IO[AwsError, zio.aws.gamelift.model.DescribeMatchmakingResponse.ReadOnly]
  def createGameSessionQueue(
      request: zio.aws.gamelift.model.CreateGameSessionQueueRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.CreateGameSessionQueueResponse.ReadOnly
  ]
  def updateRuntimeConfiguration(
      request: zio.aws.gamelift.model.UpdateRuntimeConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.UpdateRuntimeConfigurationResponse.ReadOnly
  ]
  def registerCompute(
      request: zio.aws.gamelift.model.RegisterComputeRequest
  ): IO[AwsError, zio.aws.gamelift.model.RegisterComputeResponse.ReadOnly]
  def deleteScript(
      request: zio.aws.gamelift.model.DeleteScriptRequest
  ): IO[AwsError, Unit]
  def createPlayerSessions(
      request: zio.aws.gamelift.model.CreatePlayerSessionsRequest
  ): IO[AwsError, zio.aws.gamelift.model.CreatePlayerSessionsResponse.ReadOnly]
  def stopFleetActions(
      request: zio.aws.gamelift.model.StopFleetActionsRequest
  ): IO[AwsError, zio.aws.gamelift.model.StopFleetActionsResponse.ReadOnly]
  def describeInstances(
      request: zio.aws.gamelift.model.DescribeInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.Instance.ReadOnly]
  def describeInstancesPaginated(
      request: zio.aws.gamelift.model.DescribeInstancesRequest
  ): IO[AwsError, zio.aws.gamelift.model.DescribeInstancesResponse.ReadOnly]
  def suspendGameServerGroup(
      request: zio.aws.gamelift.model.SuspendGameServerGroupRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.SuspendGameServerGroupResponse.ReadOnly
  ]
  def describeGameSessionDetails(
      request: zio.aws.gamelift.model.DescribeGameSessionDetailsRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.GameSessionDetail.ReadOnly]
  def describeGameSessionDetailsPaginated(
      request: zio.aws.gamelift.model.DescribeGameSessionDetailsRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeGameSessionDetailsResponse.ReadOnly
  ]
  def createGameServerGroup(
      request: zio.aws.gamelift.model.CreateGameServerGroupRequest
  ): IO[AwsError, zio.aws.gamelift.model.CreateGameServerGroupResponse.ReadOnly]
  def createScript(
      request: zio.aws.gamelift.model.CreateScriptRequest
  ): IO[AwsError, zio.aws.gamelift.model.CreateScriptResponse.ReadOnly]
  def describeCompute(
      request: zio.aws.gamelift.model.DescribeComputeRequest
  ): IO[AwsError, zio.aws.gamelift.model.DescribeComputeResponse.ReadOnly]
  def deregisterCompute(
      request: zio.aws.gamelift.model.DeregisterComputeRequest
  ): IO[AwsError, zio.aws.gamelift.model.DeregisterComputeResponse.ReadOnly]
  def searchGameSessions(
      request: zio.aws.gamelift.model.SearchGameSessionsRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.GameSession.ReadOnly]
  def searchGameSessionsPaginated(
      request: zio.aws.gamelift.model.SearchGameSessionsRequest
  ): IO[AwsError, zio.aws.gamelift.model.SearchGameSessionsResponse.ReadOnly]
  def startMatchBackfill(
      request: zio.aws.gamelift.model.StartMatchBackfillRequest
  ): IO[AwsError, zio.aws.gamelift.model.StartMatchBackfillResponse.ReadOnly]
  def listFleets(
      request: zio.aws.gamelift.model.ListFleetsRequest
  ): ZStream[Any, AwsError, FleetId]
  def listFleetsPaginated(
      request: zio.aws.gamelift.model.ListFleetsRequest
  ): IO[AwsError, zio.aws.gamelift.model.ListFleetsResponse.ReadOnly]
  def describeFleetUtilization(
      request: zio.aws.gamelift.model.DescribeFleetUtilizationRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.FleetUtilization.ReadOnly]
  def describeFleetUtilizationPaginated(
      request: zio.aws.gamelift.model.DescribeFleetUtilizationRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeFleetUtilizationResponse.ReadOnly
  ]
  def createPlayerSession(
      request: zio.aws.gamelift.model.CreatePlayerSessionRequest
  ): IO[AwsError, zio.aws.gamelift.model.CreatePlayerSessionResponse.ReadOnly]
  def describeGameSessionPlacement(
      request: zio.aws.gamelift.model.DescribeGameSessionPlacementRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeGameSessionPlacementResponse.ReadOnly
  ]
  def listLocations(
      request: zio.aws.gamelift.model.ListLocationsRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.LocationModel.ReadOnly]
  def listLocationsPaginated(
      request: zio.aws.gamelift.model.ListLocationsRequest
  ): IO[AwsError, zio.aws.gamelift.model.ListLocationsResponse.ReadOnly]
  def updateGameSession(
      request: zio.aws.gamelift.model.UpdateGameSessionRequest
  ): IO[AwsError, zio.aws.gamelift.model.UpdateGameSessionResponse.ReadOnly]
  def createVpcPeeringAuthorization(
      request: zio.aws.gamelift.model.CreateVpcPeeringAuthorizationRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.CreateVpcPeeringAuthorizationResponse.ReadOnly
  ]
  def describeFleetLocationCapacity(
      request: zio.aws.gamelift.model.DescribeFleetLocationCapacityRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeFleetLocationCapacityResponse.ReadOnly
  ]
  def listCompute(
      request: zio.aws.gamelift.model.ListComputeRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.Compute.ReadOnly]
  def listComputePaginated(
      request: zio.aws.gamelift.model.ListComputeRequest
  ): IO[AwsError, zio.aws.gamelift.model.ListComputeResponse.ReadOnly]
  def listScripts(
      request: zio.aws.gamelift.model.ListScriptsRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.Script.ReadOnly]
  def listScriptsPaginated(
      request: zio.aws.gamelift.model.ListScriptsRequest
  ): IO[AwsError, zio.aws.gamelift.model.ListScriptsResponse.ReadOnly]
  def describeVpcPeeringAuthorizations(
      request: zio.aws.gamelift.model.DescribeVpcPeeringAuthorizationsRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeVpcPeeringAuthorizationsResponse.ReadOnly
  ]
  def createBuild(
      request: zio.aws.gamelift.model.CreateBuildRequest
  ): IO[AwsError, zio.aws.gamelift.model.CreateBuildResponse.ReadOnly]
  def deleteFleet(
      request: zio.aws.gamelift.model.DeleteFleetRequest
  ): IO[AwsError, Unit]
  def describeMatchmakingRuleSets(
      request: zio.aws.gamelift.model.DescribeMatchmakingRuleSetsRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.MatchmakingRuleSet.ReadOnly]
  def describeMatchmakingRuleSetsPaginated(
      request: zio.aws.gamelift.model.DescribeMatchmakingRuleSetsRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeMatchmakingRuleSetsResponse.ReadOnly
  ]
  def putScalingPolicy(
      request: zio.aws.gamelift.model.PutScalingPolicyRequest
  ): IO[AwsError, zio.aws.gamelift.model.PutScalingPolicyResponse.ReadOnly]
  def deleteGameServerGroup(
      request: zio.aws.gamelift.model.DeleteGameServerGroupRequest
  ): IO[AwsError, zio.aws.gamelift.model.DeleteGameServerGroupResponse.ReadOnly]
  def updateGameSessionQueue(
      request: zio.aws.gamelift.model.UpdateGameSessionQueueRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.UpdateGameSessionQueueResponse.ReadOnly
  ]
  def stopGameSessionPlacement(
      request: zio.aws.gamelift.model.StopGameSessionPlacementRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.StopGameSessionPlacementResponse.ReadOnly
  ]
  def createLocation(
      request: zio.aws.gamelift.model.CreateLocationRequest
  ): IO[AwsError, zio.aws.gamelift.model.CreateLocationResponse.ReadOnly]
  def describeGameServerGroup(
      request: zio.aws.gamelift.model.DescribeGameServerGroupRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeGameServerGroupResponse.ReadOnly
  ]
  def deleteVpcPeeringAuthorization(
      request: zio.aws.gamelift.model.DeleteVpcPeeringAuthorizationRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DeleteVpcPeeringAuthorizationResponse.ReadOnly
  ]
  def registerGameServer(
      request: zio.aws.gamelift.model.RegisterGameServerRequest
  ): IO[AwsError, zio.aws.gamelift.model.RegisterGameServerResponse.ReadOnly]
  def describeFleetAttributes(
      request: zio.aws.gamelift.model.DescribeFleetAttributesRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.FleetAttributes.ReadOnly]
  def describeFleetAttributesPaginated(
      request: zio.aws.gamelift.model.DescribeFleetAttributesRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeFleetAttributesResponse.ReadOnly
  ]
  def deleteVpcPeeringConnection(
      request: zio.aws.gamelift.model.DeleteVpcPeeringConnectionRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DeleteVpcPeeringConnectionResponse.ReadOnly
  ]
  def describeRuntimeConfiguration(
      request: zio.aws.gamelift.model.DescribeRuntimeConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeRuntimeConfigurationResponse.ReadOnly
  ]
  def listAliases(
      request: zio.aws.gamelift.model.ListAliasesRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.Alias.ReadOnly]
  def listAliasesPaginated(
      request: zio.aws.gamelift.model.ListAliasesRequest
  ): IO[AwsError, zio.aws.gamelift.model.ListAliasesResponse.ReadOnly]
  def getGameSessionLogUrl(
      request: zio.aws.gamelift.model.GetGameSessionLogUrlRequest
  ): IO[AwsError, zio.aws.gamelift.model.GetGameSessionLogUrlResponse.ReadOnly]
  def describeAlias(
      request: zio.aws.gamelift.model.DescribeAliasRequest
  ): IO[AwsError, zio.aws.gamelift.model.DescribeAliasResponse.ReadOnly]
  def deleteLocation(
      request: zio.aws.gamelift.model.DeleteLocationRequest
  ): IO[AwsError, zio.aws.gamelift.model.DeleteLocationResponse.ReadOnly]
  def createFleet(
      request: zio.aws.gamelift.model.CreateFleetRequest
  ): IO[AwsError, zio.aws.gamelift.model.CreateFleetResponse.ReadOnly]
  def describeScalingPolicies(
      request: zio.aws.gamelift.model.DescribeScalingPoliciesRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.ScalingPolicy.ReadOnly]
  def describeScalingPoliciesPaginated(
      request: zio.aws.gamelift.model.DescribeScalingPoliciesRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeScalingPoliciesResponse.ReadOnly
  ]
  def updateAlias(
      request: zio.aws.gamelift.model.UpdateAliasRequest
  ): IO[AwsError, zio.aws.gamelift.model.UpdateAliasResponse.ReadOnly]
  def untagResource(
      request: zio.aws.gamelift.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.gamelift.model.UntagResourceResponse.ReadOnly]
  def createAlias(
      request: zio.aws.gamelift.model.CreateAliasRequest
  ): IO[AwsError, zio.aws.gamelift.model.CreateAliasResponse.ReadOnly]
  def updateFleetAttributes(
      request: zio.aws.gamelift.model.UpdateFleetAttributesRequest
  ): IO[AwsError, zio.aws.gamelift.model.UpdateFleetAttributesResponse.ReadOnly]
  def describeFleetLocationUtilization(
      request: zio.aws.gamelift.model.DescribeFleetLocationUtilizationRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeFleetLocationUtilizationResponse.ReadOnly
  ]
  def describeGameServer(
      request: zio.aws.gamelift.model.DescribeGameServerRequest
  ): IO[AwsError, zio.aws.gamelift.model.DescribeGameServerResponse.ReadOnly]
  def deleteGameSessionQueue(
      request: zio.aws.gamelift.model.DeleteGameSessionQueueRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DeleteGameSessionQueueResponse.ReadOnly
  ]
  def startFleetActions(
      request: zio.aws.gamelift.model.StartFleetActionsRequest
  ): IO[AwsError, zio.aws.gamelift.model.StartFleetActionsResponse.ReadOnly]
  def requestUploadCredentials(
      request: zio.aws.gamelift.model.RequestUploadCredentialsRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.RequestUploadCredentialsResponse.ReadOnly
  ]
  def deleteFleetLocations(
      request: zio.aws.gamelift.model.DeleteFleetLocationsRequest
  ): IO[AwsError, zio.aws.gamelift.model.DeleteFleetLocationsResponse.ReadOnly]
  def describePlayerSessions(
      request: zio.aws.gamelift.model.DescribePlayerSessionsRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.PlayerSession.ReadOnly]
  def describePlayerSessionsPaginated(
      request: zio.aws.gamelift.model.DescribePlayerSessionsRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribePlayerSessionsResponse.ReadOnly
  ]
  def resumeGameServerGroup(
      request: zio.aws.gamelift.model.ResumeGameServerGroupRequest
  ): IO[AwsError, zio.aws.gamelift.model.ResumeGameServerGroupResponse.ReadOnly]
  def startGameSessionPlacement(
      request: zio.aws.gamelift.model.StartGameSessionPlacementRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.StartGameSessionPlacementResponse.ReadOnly
  ]
  def createVpcPeeringConnection(
      request: zio.aws.gamelift.model.CreateVpcPeeringConnectionRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.CreateVpcPeeringConnectionResponse.ReadOnly
  ]
  def stopMatchmaking(
      request: zio.aws.gamelift.model.StopMatchmakingRequest
  ): IO[AwsError, zio.aws.gamelift.model.StopMatchmakingResponse.ReadOnly]
  def claimGameServer(
      request: zio.aws.gamelift.model.ClaimGameServerRequest
  ): IO[AwsError, zio.aws.gamelift.model.ClaimGameServerResponse.ReadOnly]
  def describeFleetCapacity(
      request: zio.aws.gamelift.model.DescribeFleetCapacityRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.FleetCapacity.ReadOnly]
  def describeFleetCapacityPaginated(
      request: zio.aws.gamelift.model.DescribeFleetCapacityRequest
  ): IO[AwsError, zio.aws.gamelift.model.DescribeFleetCapacityResponse.ReadOnly]
  def validateMatchmakingRuleSet(
      request: zio.aws.gamelift.model.ValidateMatchmakingRuleSetRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.ValidateMatchmakingRuleSetResponse.ReadOnly
  ]
  def deleteMatchmakingConfiguration(
      request: zio.aws.gamelift.model.DeleteMatchmakingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DeleteMatchmakingConfigurationResponse.ReadOnly
  ]
  def describeFleetPortSettings(
      request: zio.aws.gamelift.model.DescribeFleetPortSettingsRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeFleetPortSettingsResponse.ReadOnly
  ]
  def describeGameSessionQueues(
      request: zio.aws.gamelift.model.DescribeGameSessionQueuesRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.GameSessionQueue.ReadOnly]
  def describeGameSessionQueuesPaginated(
      request: zio.aws.gamelift.model.DescribeGameSessionQueuesRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeGameSessionQueuesResponse.ReadOnly
  ]
  def createFleetLocations(
      request: zio.aws.gamelift.model.CreateFleetLocationsRequest
  ): IO[AwsError, zio.aws.gamelift.model.CreateFleetLocationsResponse.ReadOnly]
  def createMatchmakingConfiguration(
      request: zio.aws.gamelift.model.CreateMatchmakingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.CreateMatchmakingConfigurationResponse.ReadOnly
  ]
  def getInstanceAccess(
      request: zio.aws.gamelift.model.GetInstanceAccessRequest
  ): IO[AwsError, zio.aws.gamelift.model.GetInstanceAccessResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.gamelift.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.gamelift.model.ListTagsForResourceResponse.ReadOnly]
  def updateBuild(
      request: zio.aws.gamelift.model.UpdateBuildRequest
  ): IO[AwsError, zio.aws.gamelift.model.UpdateBuildResponse.ReadOnly]
  def describeEC2InstanceLimits(
      request: zio.aws.gamelift.model.DescribeEc2InstanceLimitsRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeEc2InstanceLimitsResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.gamelift.model.TagResourceRequest
  ): IO[AwsError, zio.aws.gamelift.model.TagResourceResponse.ReadOnly]
  def describeBuild(
      request: zio.aws.gamelift.model.DescribeBuildRequest
  ): IO[AwsError, zio.aws.gamelift.model.DescribeBuildResponse.ReadOnly]
  def describeGameSessions(
      request: zio.aws.gamelift.model.DescribeGameSessionsRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.GameSession.ReadOnly]
  def describeGameSessionsPaginated(
      request: zio.aws.gamelift.model.DescribeGameSessionsRequest
  ): IO[AwsError, zio.aws.gamelift.model.DescribeGameSessionsResponse.ReadOnly]
  def deleteAlias(
      request: zio.aws.gamelift.model.DeleteAliasRequest
  ): IO[AwsError, Unit]
  def deregisterGameServer(
      request: zio.aws.gamelift.model.DeregisterGameServerRequest
  ): IO[AwsError, Unit]
  def createMatchmakingRuleSet(
      request: zio.aws.gamelift.model.CreateMatchmakingRuleSetRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.CreateMatchmakingRuleSetResponse.ReadOnly
  ]
  def listGameServerGroups(
      request: zio.aws.gamelift.model.ListGameServerGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.GameServerGroup.ReadOnly]
  def listGameServerGroupsPaginated(
      request: zio.aws.gamelift.model.ListGameServerGroupsRequest
  ): IO[AwsError, zio.aws.gamelift.model.ListGameServerGroupsResponse.ReadOnly]
  def createGameSession(
      request: zio.aws.gamelift.model.CreateGameSessionRequest
  ): IO[AwsError, zio.aws.gamelift.model.CreateGameSessionResponse.ReadOnly]
  def describeFleetLocationAttributes(
      request: zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly,
    zio.aws.gamelift.model.LocationAttributes.ReadOnly
  ]]
  def describeFleetLocationAttributesPaginated(
      request: zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly
  ]
  def describeScript(
      request: zio.aws.gamelift.model.DescribeScriptRequest
  ): IO[AwsError, zio.aws.gamelift.model.DescribeScriptResponse.ReadOnly]
  def describeGameServerInstances(
      request: zio.aws.gamelift.model.DescribeGameServerInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.GameServerInstance.ReadOnly]
  def describeGameServerInstancesPaginated(
      request: zio.aws.gamelift.model.DescribeGameServerInstancesRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeGameServerInstancesResponse.ReadOnly
  ]
  def listBuilds(
      request: zio.aws.gamelift.model.ListBuildsRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.Build.ReadOnly]
  def listBuildsPaginated(
      request: zio.aws.gamelift.model.ListBuildsRequest
  ): IO[AwsError, zio.aws.gamelift.model.ListBuildsResponse.ReadOnly]
  def getComputeAccess(
      request: zio.aws.gamelift.model.GetComputeAccessRequest
  ): IO[AwsError, zio.aws.gamelift.model.GetComputeAccessResponse.ReadOnly]
  def acceptMatch(
      request: zio.aws.gamelift.model.AcceptMatchRequest
  ): IO[AwsError, zio.aws.gamelift.model.AcceptMatchResponse.ReadOnly]
  def deleteMatchmakingRuleSet(
      request: zio.aws.gamelift.model.DeleteMatchmakingRuleSetRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DeleteMatchmakingRuleSetResponse.ReadOnly
  ]
  def updateMatchmakingConfiguration(
      request: zio.aws.gamelift.model.UpdateMatchmakingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.UpdateMatchmakingConfigurationResponse.ReadOnly
  ]
  def resolveAlias(
      request: zio.aws.gamelift.model.ResolveAliasRequest
  ): IO[AwsError, zio.aws.gamelift.model.ResolveAliasResponse.ReadOnly]
  def deleteScalingPolicy(
      request: zio.aws.gamelift.model.DeleteScalingPolicyRequest
  ): IO[AwsError, Unit]
  def listGameServers(
      request: zio.aws.gamelift.model.ListGameServersRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.GameServer.ReadOnly]
  def listGameServersPaginated(
      request: zio.aws.gamelift.model.ListGameServersRequest
  ): IO[AwsError, zio.aws.gamelift.model.ListGameServersResponse.ReadOnly]
  def updateFleetCapacity(
      request: zio.aws.gamelift.model.UpdateFleetCapacityRequest
  ): IO[AwsError, zio.aws.gamelift.model.UpdateFleetCapacityResponse.ReadOnly]
  def updateGameServerGroup(
      request: zio.aws.gamelift.model.UpdateGameServerGroupRequest
  ): IO[AwsError, zio.aws.gamelift.model.UpdateGameServerGroupResponse.ReadOnly]
  def describeFleetEvents(
      request: zio.aws.gamelift.model.DescribeFleetEventsRequest
  ): ZStream[Any, AwsError, zio.aws.gamelift.model.Event.ReadOnly]
  def describeFleetEventsPaginated(
      request: zio.aws.gamelift.model.DescribeFleetEventsRequest
  ): IO[AwsError, zio.aws.gamelift.model.DescribeFleetEventsResponse.ReadOnly]
  def updateScript(
      request: zio.aws.gamelift.model.UpdateScriptRequest
  ): IO[AwsError, zio.aws.gamelift.model.UpdateScriptResponse.ReadOnly]
  def describeMatchmakingConfigurations(
      request: zio.aws.gamelift.model.DescribeMatchmakingConfigurationsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def describeMatchmakingConfigurationsPaginated(
      request: zio.aws.gamelift.model.DescribeMatchmakingConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.gamelift.model.DescribeMatchmakingConfigurationsResponse.ReadOnly
  ]
}
object GameLift {
  val live: ZLayer[AwsConfig, java.lang.Throwable, GameLift] = customized(
    identity
  )
  def customized(
      customization: GameLiftAsyncClientBuilder => GameLiftAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, GameLift] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: GameLiftAsyncClientBuilder => GameLiftAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, GameLift] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = GameLiftAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[GameLiftAsyncClient, GameLiftAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[GameLiftAsyncClient, GameLiftAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new GameLiftImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class GameLiftImpl[R](
      override val api: GameLiftAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends GameLift
      with AwsServiceBase[R] {
    override val serviceName: String = "GameLift"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): GameLiftImpl[R1] = new GameLiftImpl(api, newAspect, r)
    def deleteBuild(
        request: zio.aws.gamelift.model.DeleteBuildRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteBuildRequest, DeleteBuildResponse](
        "deleteBuild",
        api.deleteBuild
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeVpcPeeringConnections(
        request: zio.aws.gamelift.model.DescribeVpcPeeringConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeVpcPeeringConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVpcPeeringConnectionsRequest,
      DescribeVpcPeeringConnectionsResponse
    ]("describeVpcPeeringConnections", api.describeVpcPeeringConnections)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeVpcPeeringConnectionsResponse.wrap)
      .provideEnvironment(r)
    def startMatchmaking(
        request: zio.aws.gamelift.model.StartMatchmakingRequest
    ): IO[AwsError, zio.aws.gamelift.model.StartMatchmakingResponse.ReadOnly] =
      asyncRequestResponse[StartMatchmakingRequest, StartMatchmakingResponse](
        "startMatchmaking",
        api.startMatchmaking
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.StartMatchmakingResponse.wrap)
        .provideEnvironment(r)
    def updateGameServer(
        request: zio.aws.gamelift.model.UpdateGameServerRequest
    ): IO[AwsError, zio.aws.gamelift.model.UpdateGameServerResponse.ReadOnly] =
      asyncRequestResponse[UpdateGameServerRequest, UpdateGameServerResponse](
        "updateGameServer",
        api.updateGameServer
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.UpdateGameServerResponse.wrap)
        .provideEnvironment(r)
    def getComputeAuthToken(
        request: zio.aws.gamelift.model.GetComputeAuthTokenRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.GetComputeAuthTokenResponse.ReadOnly
    ] = asyncRequestResponse[
      GetComputeAuthTokenRequest,
      GetComputeAuthTokenResponse
    ]("getComputeAuthToken", api.getComputeAuthToken)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.GetComputeAuthTokenResponse.wrap)
      .provideEnvironment(r)
    def updateFleetPortSettings(
        request: zio.aws.gamelift.model.UpdateFleetPortSettingsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.UpdateFleetPortSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateFleetPortSettingsRequest,
      UpdateFleetPortSettingsResponse
    ]("updateFleetPortSettings", api.updateFleetPortSettings)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.UpdateFleetPortSettingsResponse.wrap)
      .provideEnvironment(r)
    def describeMatchmaking(
        request: zio.aws.gamelift.model.DescribeMatchmakingRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeMatchmakingResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMatchmakingRequest,
      DescribeMatchmakingResponse
    ]("describeMatchmaking", api.describeMatchmaking)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.DescribeMatchmakingResponse.wrap)
      .provideEnvironment(r)
    def createGameSessionQueue(
        request: zio.aws.gamelift.model.CreateGameSessionQueueRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.CreateGameSessionQueueResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateGameSessionQueueRequest,
      CreateGameSessionQueueResponse
    ]("createGameSessionQueue", api.createGameSessionQueue)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.CreateGameSessionQueueResponse.wrap)
      .provideEnvironment(r)
    def updateRuntimeConfiguration(
        request: zio.aws.gamelift.model.UpdateRuntimeConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.UpdateRuntimeConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateRuntimeConfigurationRequest,
      UpdateRuntimeConfigurationResponse
    ]("updateRuntimeConfiguration", api.updateRuntimeConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.UpdateRuntimeConfigurationResponse.wrap)
      .provideEnvironment(r)
    def registerCompute(
        request: zio.aws.gamelift.model.RegisterComputeRequest
    ): IO[AwsError, zio.aws.gamelift.model.RegisterComputeResponse.ReadOnly] =
      asyncRequestResponse[RegisterComputeRequest, RegisterComputeResponse](
        "registerCompute",
        api.registerCompute
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.RegisterComputeResponse.wrap)
        .provideEnvironment(r)
    def deleteScript(
        request: zio.aws.gamelift.model.DeleteScriptRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteScriptRequest, DeleteScriptResponse](
        "deleteScript",
        api.deleteScript
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createPlayerSessions(
        request: zio.aws.gamelift.model.CreatePlayerSessionsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.CreatePlayerSessionsResponse.ReadOnly
    ] = asyncRequestResponse[
      CreatePlayerSessionsRequest,
      CreatePlayerSessionsResponse
    ]("createPlayerSessions", api.createPlayerSessions)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.CreatePlayerSessionsResponse.wrap)
      .provideEnvironment(r)
    def stopFleetActions(
        request: zio.aws.gamelift.model.StopFleetActionsRequest
    ): IO[AwsError, zio.aws.gamelift.model.StopFleetActionsResponse.ReadOnly] =
      asyncRequestResponse[StopFleetActionsRequest, StopFleetActionsResponse](
        "stopFleetActions",
        api.stopFleetActions
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.StopFleetActionsResponse.wrap)
        .provideEnvironment(r)
    def describeInstances(
        request: zio.aws.gamelift.model.DescribeInstancesRequest
    ): ZStream[Any, AwsError, zio.aws.gamelift.model.Instance.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeInstancesRequest,
        DescribeInstancesResponse,
        Instance
      ](
        "describeInstances",
        api.describeInstances,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.instances().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.gamelift.model.Instance.wrap(item))
        .provideEnvironment(r)
    def describeInstancesPaginated(
        request: zio.aws.gamelift.model.DescribeInstancesRequest
    ): IO[AwsError, zio.aws.gamelift.model.DescribeInstancesResponse.ReadOnly] =
      asyncRequestResponse[DescribeInstancesRequest, DescribeInstancesResponse](
        "describeInstances",
        api.describeInstances
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.DescribeInstancesResponse.wrap)
        .provideEnvironment(r)
    def suspendGameServerGroup(
        request: zio.aws.gamelift.model.SuspendGameServerGroupRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.SuspendGameServerGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      SuspendGameServerGroupRequest,
      SuspendGameServerGroupResponse
    ]("suspendGameServerGroup", api.suspendGameServerGroup)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.SuspendGameServerGroupResponse.wrap)
      .provideEnvironment(r)
    def describeGameSessionDetails(
        request: zio.aws.gamelift.model.DescribeGameSessionDetailsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameSessionDetail.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeGameSessionDetailsRequest,
      DescribeGameSessionDetailsResponse,
      GameSessionDetail
    ](
      "describeGameSessionDetails",
      api.describeGameSessionDetails,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.gameSessionDetails().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.gamelift.model.GameSessionDetail.wrap(item))
      .provideEnvironment(r)
    def describeGameSessionDetailsPaginated(
        request: zio.aws.gamelift.model.DescribeGameSessionDetailsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeGameSessionDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeGameSessionDetailsRequest,
      DescribeGameSessionDetailsResponse
    ]("describeGameSessionDetails", api.describeGameSessionDetails)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeGameSessionDetailsResponse.wrap)
      .provideEnvironment(r)
    def createGameServerGroup(
        request: zio.aws.gamelift.model.CreateGameServerGroupRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.CreateGameServerGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateGameServerGroupRequest,
      CreateGameServerGroupResponse
    ]("createGameServerGroup", api.createGameServerGroup)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.CreateGameServerGroupResponse.wrap)
      .provideEnvironment(r)
    def createScript(
        request: zio.aws.gamelift.model.CreateScriptRequest
    ): IO[AwsError, zio.aws.gamelift.model.CreateScriptResponse.ReadOnly] =
      asyncRequestResponse[CreateScriptRequest, CreateScriptResponse](
        "createScript",
        api.createScript
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.CreateScriptResponse.wrap)
        .provideEnvironment(r)
    def describeCompute(
        request: zio.aws.gamelift.model.DescribeComputeRequest
    ): IO[AwsError, zio.aws.gamelift.model.DescribeComputeResponse.ReadOnly] =
      asyncRequestResponse[DescribeComputeRequest, DescribeComputeResponse](
        "describeCompute",
        api.describeCompute
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.DescribeComputeResponse.wrap)
        .provideEnvironment(r)
    def deregisterCompute(
        request: zio.aws.gamelift.model.DeregisterComputeRequest
    ): IO[AwsError, zio.aws.gamelift.model.DeregisterComputeResponse.ReadOnly] =
      asyncRequestResponse[DeregisterComputeRequest, DeregisterComputeResponse](
        "deregisterCompute",
        api.deregisterCompute
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.DeregisterComputeResponse.wrap)
        .provideEnvironment(r)
    def searchGameSessions(
        request: zio.aws.gamelift.model.SearchGameSessionsRequest
    ): ZStream[Any, AwsError, zio.aws.gamelift.model.GameSession.ReadOnly] =
      asyncSimplePaginatedRequest[
        SearchGameSessionsRequest,
        SearchGameSessionsResponse,
        GameSession
      ](
        "searchGameSessions",
        api.searchGameSessions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.gameSessions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.gamelift.model.GameSession.wrap(item))
        .provideEnvironment(r)
    def searchGameSessionsPaginated(
        request: zio.aws.gamelift.model.SearchGameSessionsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.SearchGameSessionsResponse.ReadOnly
    ] = asyncRequestResponse[
      SearchGameSessionsRequest,
      SearchGameSessionsResponse
    ]("searchGameSessions", api.searchGameSessions)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.SearchGameSessionsResponse.wrap)
      .provideEnvironment(r)
    def startMatchBackfill(
        request: zio.aws.gamelift.model.StartMatchBackfillRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.StartMatchBackfillResponse.ReadOnly
    ] = asyncRequestResponse[
      StartMatchBackfillRequest,
      StartMatchBackfillResponse
    ]("startMatchBackfill", api.startMatchBackfill)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.StartMatchBackfillResponse.wrap)
      .provideEnvironment(r)
    def listFleets(
        request: zio.aws.gamelift.model.ListFleetsRequest
    ): ZStream[Any, AwsError, FleetId] = asyncSimplePaginatedRequest[
      ListFleetsRequest,
      ListFleetsResponse,
      java.lang.String
    ](
      "listFleets",
      api.listFleets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.fleetIds().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.gamelift.model.primitives.FleetId(item))
      .provideEnvironment(r)
    def listFleetsPaginated(
        request: zio.aws.gamelift.model.ListFleetsRequest
    ): IO[AwsError, zio.aws.gamelift.model.ListFleetsResponse.ReadOnly] =
      asyncRequestResponse[ListFleetsRequest, ListFleetsResponse](
        "listFleets",
        api.listFleets
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.ListFleetsResponse.wrap)
        .provideEnvironment(r)
    def describeFleetUtilization(
        request: zio.aws.gamelift.model.DescribeFleetUtilizationRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.gamelift.model.FleetUtilization.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeFleetUtilizationRequest,
      DescribeFleetUtilizationResponse,
      FleetUtilization
    ](
      "describeFleetUtilization",
      api.describeFleetUtilization,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.fleetUtilization().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.gamelift.model.FleetUtilization.wrap(item))
      .provideEnvironment(r)
    def describeFleetUtilizationPaginated(
        request: zio.aws.gamelift.model.DescribeFleetUtilizationRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeFleetUtilizationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetUtilizationRequest,
      DescribeFleetUtilizationResponse
    ]("describeFleetUtilization", api.describeFleetUtilization)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeFleetUtilizationResponse.wrap)
      .provideEnvironment(r)
    def createPlayerSession(
        request: zio.aws.gamelift.model.CreatePlayerSessionRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.CreatePlayerSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreatePlayerSessionRequest,
      CreatePlayerSessionResponse
    ]("createPlayerSession", api.createPlayerSession)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.CreatePlayerSessionResponse.wrap)
      .provideEnvironment(r)
    def describeGameSessionPlacement(
        request: zio.aws.gamelift.model.DescribeGameSessionPlacementRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeGameSessionPlacementResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeGameSessionPlacementRequest,
      DescribeGameSessionPlacementResponse
    ]("describeGameSessionPlacement", api.describeGameSessionPlacement)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeGameSessionPlacementResponse.wrap)
      .provideEnvironment(r)
    def listLocations(
        request: zio.aws.gamelift.model.ListLocationsRequest
    ): ZStream[Any, AwsError, zio.aws.gamelift.model.LocationModel.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListLocationsRequest,
        ListLocationsResponse,
        LocationModel
      ](
        "listLocations",
        api.listLocations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.locations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.gamelift.model.LocationModel.wrap(item))
        .provideEnvironment(r)
    def listLocationsPaginated(
        request: zio.aws.gamelift.model.ListLocationsRequest
    ): IO[AwsError, zio.aws.gamelift.model.ListLocationsResponse.ReadOnly] =
      asyncRequestResponse[ListLocationsRequest, ListLocationsResponse](
        "listLocations",
        api.listLocations
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.ListLocationsResponse.wrap)
        .provideEnvironment(r)
    def updateGameSession(
        request: zio.aws.gamelift.model.UpdateGameSessionRequest
    ): IO[AwsError, zio.aws.gamelift.model.UpdateGameSessionResponse.ReadOnly] =
      asyncRequestResponse[UpdateGameSessionRequest, UpdateGameSessionResponse](
        "updateGameSession",
        api.updateGameSession
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.UpdateGameSessionResponse.wrap)
        .provideEnvironment(r)
    def createVpcPeeringAuthorization(
        request: zio.aws.gamelift.model.CreateVpcPeeringAuthorizationRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.CreateVpcPeeringAuthorizationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateVpcPeeringAuthorizationRequest,
      CreateVpcPeeringAuthorizationResponse
    ]("createVpcPeeringAuthorization", api.createVpcPeeringAuthorization)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.CreateVpcPeeringAuthorizationResponse.wrap)
      .provideEnvironment(r)
    def describeFleetLocationCapacity(
        request: zio.aws.gamelift.model.DescribeFleetLocationCapacityRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeFleetLocationCapacityResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetLocationCapacityRequest,
      DescribeFleetLocationCapacityResponse
    ]("describeFleetLocationCapacity", api.describeFleetLocationCapacity)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeFleetLocationCapacityResponse.wrap)
      .provideEnvironment(r)
    def listCompute(
        request: zio.aws.gamelift.model.ListComputeRequest
    ): ZStream[Any, AwsError, zio.aws.gamelift.model.Compute.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListComputeRequest,
        ListComputeResponse,
        Compute
      ](
        "listCompute",
        api.listCompute,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.computeList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.gamelift.model.Compute.wrap(item))
        .provideEnvironment(r)
    def listComputePaginated(
        request: zio.aws.gamelift.model.ListComputeRequest
    ): IO[AwsError, zio.aws.gamelift.model.ListComputeResponse.ReadOnly] =
      asyncRequestResponse[ListComputeRequest, ListComputeResponse](
        "listCompute",
        api.listCompute
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.ListComputeResponse.wrap)
        .provideEnvironment(r)
    def listScripts(
        request: zio.aws.gamelift.model.ListScriptsRequest
    ): ZStream[Any, AwsError, zio.aws.gamelift.model.Script.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListScriptsRequest,
        ListScriptsResponse,
        Script
      ](
        "listScripts",
        api.listScripts,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.scripts().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.gamelift.model.Script.wrap(item))
        .provideEnvironment(r)
    def listScriptsPaginated(
        request: zio.aws.gamelift.model.ListScriptsRequest
    ): IO[AwsError, zio.aws.gamelift.model.ListScriptsResponse.ReadOnly] =
      asyncRequestResponse[ListScriptsRequest, ListScriptsResponse](
        "listScripts",
        api.listScripts
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.ListScriptsResponse.wrap)
        .provideEnvironment(r)
    def describeVpcPeeringAuthorizations(
        request: zio.aws.gamelift.model.DescribeVpcPeeringAuthorizationsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeVpcPeeringAuthorizationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVpcPeeringAuthorizationsRequest,
      DescribeVpcPeeringAuthorizationsResponse
    ]("describeVpcPeeringAuthorizations", api.describeVpcPeeringAuthorizations)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeVpcPeeringAuthorizationsResponse.wrap)
      .provideEnvironment(r)
    def createBuild(
        request: zio.aws.gamelift.model.CreateBuildRequest
    ): IO[AwsError, zio.aws.gamelift.model.CreateBuildResponse.ReadOnly] =
      asyncRequestResponse[CreateBuildRequest, CreateBuildResponse](
        "createBuild",
        api.createBuild
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.CreateBuildResponse.wrap)
        .provideEnvironment(r)
    def deleteFleet(
        request: zio.aws.gamelift.model.DeleteFleetRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteFleetRequest, DeleteFleetResponse](
        "deleteFleet",
        api.deleteFleet
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeMatchmakingRuleSets(
        request: zio.aws.gamelift.model.DescribeMatchmakingRuleSetsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.gamelift.model.MatchmakingRuleSet.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeMatchmakingRuleSetsRequest,
      DescribeMatchmakingRuleSetsResponse,
      MatchmakingRuleSet
    ](
      "describeMatchmakingRuleSets",
      api.describeMatchmakingRuleSets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.ruleSets().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.gamelift.model.MatchmakingRuleSet.wrap(item))
      .provideEnvironment(r)
    def describeMatchmakingRuleSetsPaginated(
        request: zio.aws.gamelift.model.DescribeMatchmakingRuleSetsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeMatchmakingRuleSetsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMatchmakingRuleSetsRequest,
      DescribeMatchmakingRuleSetsResponse
    ]("describeMatchmakingRuleSets", api.describeMatchmakingRuleSets)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeMatchmakingRuleSetsResponse.wrap)
      .provideEnvironment(r)
    def putScalingPolicy(
        request: zio.aws.gamelift.model.PutScalingPolicyRequest
    ): IO[AwsError, zio.aws.gamelift.model.PutScalingPolicyResponse.ReadOnly] =
      asyncRequestResponse[PutScalingPolicyRequest, PutScalingPolicyResponse](
        "putScalingPolicy",
        api.putScalingPolicy
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.PutScalingPolicyResponse.wrap)
        .provideEnvironment(r)
    def deleteGameServerGroup(
        request: zio.aws.gamelift.model.DeleteGameServerGroupRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DeleteGameServerGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteGameServerGroupRequest,
      DeleteGameServerGroupResponse
    ]("deleteGameServerGroup", api.deleteGameServerGroup)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DeleteGameServerGroupResponse.wrap)
      .provideEnvironment(r)
    def updateGameSessionQueue(
        request: zio.aws.gamelift.model.UpdateGameSessionQueueRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.UpdateGameSessionQueueResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateGameSessionQueueRequest,
      UpdateGameSessionQueueResponse
    ]("updateGameSessionQueue", api.updateGameSessionQueue)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.UpdateGameSessionQueueResponse.wrap)
      .provideEnvironment(r)
    def stopGameSessionPlacement(
        request: zio.aws.gamelift.model.StopGameSessionPlacementRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.StopGameSessionPlacementResponse.ReadOnly
    ] = asyncRequestResponse[
      StopGameSessionPlacementRequest,
      StopGameSessionPlacementResponse
    ]("stopGameSessionPlacement", api.stopGameSessionPlacement)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.StopGameSessionPlacementResponse.wrap)
      .provideEnvironment(r)
    def createLocation(
        request: zio.aws.gamelift.model.CreateLocationRequest
    ): IO[AwsError, zio.aws.gamelift.model.CreateLocationResponse.ReadOnly] =
      asyncRequestResponse[CreateLocationRequest, CreateLocationResponse](
        "createLocation",
        api.createLocation
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.CreateLocationResponse.wrap)
        .provideEnvironment(r)
    def describeGameServerGroup(
        request: zio.aws.gamelift.model.DescribeGameServerGroupRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeGameServerGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeGameServerGroupRequest,
      DescribeGameServerGroupResponse
    ]("describeGameServerGroup", api.describeGameServerGroup)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeGameServerGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteVpcPeeringAuthorization(
        request: zio.aws.gamelift.model.DeleteVpcPeeringAuthorizationRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DeleteVpcPeeringAuthorizationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteVpcPeeringAuthorizationRequest,
      DeleteVpcPeeringAuthorizationResponse
    ]("deleteVpcPeeringAuthorization", api.deleteVpcPeeringAuthorization)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DeleteVpcPeeringAuthorizationResponse.wrap)
      .provideEnvironment(r)
    def registerGameServer(
        request: zio.aws.gamelift.model.RegisterGameServerRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.RegisterGameServerResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterGameServerRequest,
      RegisterGameServerResponse
    ]("registerGameServer", api.registerGameServer)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.RegisterGameServerResponse.wrap)
      .provideEnvironment(r)
    def describeFleetAttributes(
        request: zio.aws.gamelift.model.DescribeFleetAttributesRequest
    ): ZStream[Any, AwsError, zio.aws.gamelift.model.FleetAttributes.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeFleetAttributesRequest,
        DescribeFleetAttributesResponse,
        FleetAttributes
      ](
        "describeFleetAttributes",
        api.describeFleetAttributes,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.fleetAttributes().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.gamelift.model.FleetAttributes.wrap(item))
        .provideEnvironment(r)
    def describeFleetAttributesPaginated(
        request: zio.aws.gamelift.model.DescribeFleetAttributesRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeFleetAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetAttributesRequest,
      DescribeFleetAttributesResponse
    ]("describeFleetAttributes", api.describeFleetAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeFleetAttributesResponse.wrap)
      .provideEnvironment(r)
    def deleteVpcPeeringConnection(
        request: zio.aws.gamelift.model.DeleteVpcPeeringConnectionRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DeleteVpcPeeringConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteVpcPeeringConnectionRequest,
      DeleteVpcPeeringConnectionResponse
    ]("deleteVpcPeeringConnection", api.deleteVpcPeeringConnection)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DeleteVpcPeeringConnectionResponse.wrap)
      .provideEnvironment(r)
    def describeRuntimeConfiguration(
        request: zio.aws.gamelift.model.DescribeRuntimeConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeRuntimeConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRuntimeConfigurationRequest,
      DescribeRuntimeConfigurationResponse
    ]("describeRuntimeConfiguration", api.describeRuntimeConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeRuntimeConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listAliases(
        request: zio.aws.gamelift.model.ListAliasesRequest
    ): ZStream[Any, AwsError, zio.aws.gamelift.model.Alias.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListAliasesRequest,
        ListAliasesResponse,
        Alias
      ](
        "listAliases",
        api.listAliases,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.aliases().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.gamelift.model.Alias.wrap(item))
        .provideEnvironment(r)
    def listAliasesPaginated(
        request: zio.aws.gamelift.model.ListAliasesRequest
    ): IO[AwsError, zio.aws.gamelift.model.ListAliasesResponse.ReadOnly] =
      asyncRequestResponse[ListAliasesRequest, ListAliasesResponse](
        "listAliases",
        api.listAliases
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.ListAliasesResponse.wrap)
        .provideEnvironment(r)
    def getGameSessionLogUrl(
        request: zio.aws.gamelift.model.GetGameSessionLogUrlRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.GetGameSessionLogUrlResponse.ReadOnly
    ] = asyncRequestResponse[
      GetGameSessionLogUrlRequest,
      GetGameSessionLogUrlResponse
    ]("getGameSessionLogUrl", api.getGameSessionLogUrl)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.GetGameSessionLogUrlResponse.wrap)
      .provideEnvironment(r)
    def describeAlias(
        request: zio.aws.gamelift.model.DescribeAliasRequest
    ): IO[AwsError, zio.aws.gamelift.model.DescribeAliasResponse.ReadOnly] =
      asyncRequestResponse[DescribeAliasRequest, DescribeAliasResponse](
        "describeAlias",
        api.describeAlias
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.DescribeAliasResponse.wrap)
        .provideEnvironment(r)
    def deleteLocation(
        request: zio.aws.gamelift.model.DeleteLocationRequest
    ): IO[AwsError, zio.aws.gamelift.model.DeleteLocationResponse.ReadOnly] =
      asyncRequestResponse[DeleteLocationRequest, DeleteLocationResponse](
        "deleteLocation",
        api.deleteLocation
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.DeleteLocationResponse.wrap)
        .provideEnvironment(r)
    def createFleet(
        request: zio.aws.gamelift.model.CreateFleetRequest
    ): IO[AwsError, zio.aws.gamelift.model.CreateFleetResponse.ReadOnly] =
      asyncRequestResponse[CreateFleetRequest, CreateFleetResponse](
        "createFleet",
        api.createFleet
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.CreateFleetResponse.wrap)
        .provideEnvironment(r)
    def describeScalingPolicies(
        request: zio.aws.gamelift.model.DescribeScalingPoliciesRequest
    ): ZStream[Any, AwsError, zio.aws.gamelift.model.ScalingPolicy.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeScalingPoliciesRequest,
        DescribeScalingPoliciesResponse,
        ScalingPolicy
      ](
        "describeScalingPolicies",
        api.describeScalingPolicies,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.scalingPolicies().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.gamelift.model.ScalingPolicy.wrap(item))
        .provideEnvironment(r)
    def describeScalingPoliciesPaginated(
        request: zio.aws.gamelift.model.DescribeScalingPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeScalingPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeScalingPoliciesRequest,
      DescribeScalingPoliciesResponse
    ]("describeScalingPolicies", api.describeScalingPolicies)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeScalingPoliciesResponse.wrap)
      .provideEnvironment(r)
    def updateAlias(
        request: zio.aws.gamelift.model.UpdateAliasRequest
    ): IO[AwsError, zio.aws.gamelift.model.UpdateAliasResponse.ReadOnly] =
      asyncRequestResponse[UpdateAliasRequest, UpdateAliasResponse](
        "updateAlias",
        api.updateAlias
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.UpdateAliasResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.gamelift.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.gamelift.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createAlias(
        request: zio.aws.gamelift.model.CreateAliasRequest
    ): IO[AwsError, zio.aws.gamelift.model.CreateAliasResponse.ReadOnly] =
      asyncRequestResponse[CreateAliasRequest, CreateAliasResponse](
        "createAlias",
        api.createAlias
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.CreateAliasResponse.wrap)
        .provideEnvironment(r)
    def updateFleetAttributes(
        request: zio.aws.gamelift.model.UpdateFleetAttributesRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.UpdateFleetAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateFleetAttributesRequest,
      UpdateFleetAttributesResponse
    ]("updateFleetAttributes", api.updateFleetAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.UpdateFleetAttributesResponse.wrap)
      .provideEnvironment(r)
    def describeFleetLocationUtilization(
        request: zio.aws.gamelift.model.DescribeFleetLocationUtilizationRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeFleetLocationUtilizationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetLocationUtilizationRequest,
      DescribeFleetLocationUtilizationResponse
    ]("describeFleetLocationUtilization", api.describeFleetLocationUtilization)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeFleetLocationUtilizationResponse.wrap)
      .provideEnvironment(r)
    def describeGameServer(
        request: zio.aws.gamelift.model.DescribeGameServerRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeGameServerResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeGameServerRequest,
      DescribeGameServerResponse
    ]("describeGameServer", api.describeGameServer)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.DescribeGameServerResponse.wrap)
      .provideEnvironment(r)
    def deleteGameSessionQueue(
        request: zio.aws.gamelift.model.DeleteGameSessionQueueRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DeleteGameSessionQueueResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteGameSessionQueueRequest,
      DeleteGameSessionQueueResponse
    ]("deleteGameSessionQueue", api.deleteGameSessionQueue)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DeleteGameSessionQueueResponse.wrap)
      .provideEnvironment(r)
    def startFleetActions(
        request: zio.aws.gamelift.model.StartFleetActionsRequest
    ): IO[AwsError, zio.aws.gamelift.model.StartFleetActionsResponse.ReadOnly] =
      asyncRequestResponse[StartFleetActionsRequest, StartFleetActionsResponse](
        "startFleetActions",
        api.startFleetActions
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.StartFleetActionsResponse.wrap)
        .provideEnvironment(r)
    def requestUploadCredentials(
        request: zio.aws.gamelift.model.RequestUploadCredentialsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.RequestUploadCredentialsResponse.ReadOnly
    ] = asyncRequestResponse[
      RequestUploadCredentialsRequest,
      RequestUploadCredentialsResponse
    ]("requestUploadCredentials", api.requestUploadCredentials)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.RequestUploadCredentialsResponse.wrap)
      .provideEnvironment(r)
    def deleteFleetLocations(
        request: zio.aws.gamelift.model.DeleteFleetLocationsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DeleteFleetLocationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteFleetLocationsRequest,
      DeleteFleetLocationsResponse
    ]("deleteFleetLocations", api.deleteFleetLocations)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.DeleteFleetLocationsResponse.wrap)
      .provideEnvironment(r)
    def describePlayerSessions(
        request: zio.aws.gamelift.model.DescribePlayerSessionsRequest
    ): ZStream[Any, AwsError, zio.aws.gamelift.model.PlayerSession.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribePlayerSessionsRequest,
        DescribePlayerSessionsResponse,
        PlayerSession
      ](
        "describePlayerSessions",
        api.describePlayerSessions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.playerSessions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.gamelift.model.PlayerSession.wrap(item))
        .provideEnvironment(r)
    def describePlayerSessionsPaginated(
        request: zio.aws.gamelift.model.DescribePlayerSessionsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribePlayerSessionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePlayerSessionsRequest,
      DescribePlayerSessionsResponse
    ]("describePlayerSessions", api.describePlayerSessions)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribePlayerSessionsResponse.wrap)
      .provideEnvironment(r)
    def resumeGameServerGroup(
        request: zio.aws.gamelift.model.ResumeGameServerGroupRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.ResumeGameServerGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      ResumeGameServerGroupRequest,
      ResumeGameServerGroupResponse
    ]("resumeGameServerGroup", api.resumeGameServerGroup)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.ResumeGameServerGroupResponse.wrap)
      .provideEnvironment(r)
    def startGameSessionPlacement(
        request: zio.aws.gamelift.model.StartGameSessionPlacementRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.StartGameSessionPlacementResponse.ReadOnly
    ] = asyncRequestResponse[
      StartGameSessionPlacementRequest,
      StartGameSessionPlacementResponse
    ]("startGameSessionPlacement", api.startGameSessionPlacement)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.StartGameSessionPlacementResponse.wrap)
      .provideEnvironment(r)
    def createVpcPeeringConnection(
        request: zio.aws.gamelift.model.CreateVpcPeeringConnectionRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.CreateVpcPeeringConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateVpcPeeringConnectionRequest,
      CreateVpcPeeringConnectionResponse
    ]("createVpcPeeringConnection", api.createVpcPeeringConnection)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.CreateVpcPeeringConnectionResponse.wrap)
      .provideEnvironment(r)
    def stopMatchmaking(
        request: zio.aws.gamelift.model.StopMatchmakingRequest
    ): IO[AwsError, zio.aws.gamelift.model.StopMatchmakingResponse.ReadOnly] =
      asyncRequestResponse[StopMatchmakingRequest, StopMatchmakingResponse](
        "stopMatchmaking",
        api.stopMatchmaking
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.StopMatchmakingResponse.wrap)
        .provideEnvironment(r)
    def claimGameServer(
        request: zio.aws.gamelift.model.ClaimGameServerRequest
    ): IO[AwsError, zio.aws.gamelift.model.ClaimGameServerResponse.ReadOnly] =
      asyncRequestResponse[ClaimGameServerRequest, ClaimGameServerResponse](
        "claimGameServer",
        api.claimGameServer
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.ClaimGameServerResponse.wrap)
        .provideEnvironment(r)
    def describeFleetCapacity(
        request: zio.aws.gamelift.model.DescribeFleetCapacityRequest
    ): ZStream[Any, AwsError, zio.aws.gamelift.model.FleetCapacity.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeFleetCapacityRequest,
        DescribeFleetCapacityResponse,
        FleetCapacity
      ](
        "describeFleetCapacity",
        api.describeFleetCapacity,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.fleetCapacity().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.gamelift.model.FleetCapacity.wrap(item))
        .provideEnvironment(r)
    def describeFleetCapacityPaginated(
        request: zio.aws.gamelift.model.DescribeFleetCapacityRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeFleetCapacityResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetCapacityRequest,
      DescribeFleetCapacityResponse
    ]("describeFleetCapacity", api.describeFleetCapacity)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeFleetCapacityResponse.wrap)
      .provideEnvironment(r)
    def validateMatchmakingRuleSet(
        request: zio.aws.gamelift.model.ValidateMatchmakingRuleSetRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.ValidateMatchmakingRuleSetResponse.ReadOnly
    ] = asyncRequestResponse[
      ValidateMatchmakingRuleSetRequest,
      ValidateMatchmakingRuleSetResponse
    ]("validateMatchmakingRuleSet", api.validateMatchmakingRuleSet)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.ValidateMatchmakingRuleSetResponse.wrap)
      .provideEnvironment(r)
    def deleteMatchmakingConfiguration(
        request: zio.aws.gamelift.model.DeleteMatchmakingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DeleteMatchmakingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteMatchmakingConfigurationRequest,
      DeleteMatchmakingConfigurationResponse
    ]("deleteMatchmakingConfiguration", api.deleteMatchmakingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DeleteMatchmakingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def describeFleetPortSettings(
        request: zio.aws.gamelift.model.DescribeFleetPortSettingsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeFleetPortSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetPortSettingsRequest,
      DescribeFleetPortSettingsResponse
    ]("describeFleetPortSettings", api.describeFleetPortSettings)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeFleetPortSettingsResponse.wrap)
      .provideEnvironment(r)
    def describeGameSessionQueues(
        request: zio.aws.gamelift.model.DescribeGameSessionQueuesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameSessionQueue.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeGameSessionQueuesRequest,
      DescribeGameSessionQueuesResponse,
      GameSessionQueue
    ](
      "describeGameSessionQueues",
      api.describeGameSessionQueues,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.gameSessionQueues().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.gamelift.model.GameSessionQueue.wrap(item))
      .provideEnvironment(r)
    def describeGameSessionQueuesPaginated(
        request: zio.aws.gamelift.model.DescribeGameSessionQueuesRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeGameSessionQueuesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeGameSessionQueuesRequest,
      DescribeGameSessionQueuesResponse
    ]("describeGameSessionQueues", api.describeGameSessionQueues)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeGameSessionQueuesResponse.wrap)
      .provideEnvironment(r)
    def createFleetLocations(
        request: zio.aws.gamelift.model.CreateFleetLocationsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.CreateFleetLocationsResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateFleetLocationsRequest,
      CreateFleetLocationsResponse
    ]("createFleetLocations", api.createFleetLocations)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.CreateFleetLocationsResponse.wrap)
      .provideEnvironment(r)
    def createMatchmakingConfiguration(
        request: zio.aws.gamelift.model.CreateMatchmakingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.CreateMatchmakingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateMatchmakingConfigurationRequest,
      CreateMatchmakingConfigurationResponse
    ]("createMatchmakingConfiguration", api.createMatchmakingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.CreateMatchmakingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def getInstanceAccess(
        request: zio.aws.gamelift.model.GetInstanceAccessRequest
    ): IO[AwsError, zio.aws.gamelift.model.GetInstanceAccessResponse.ReadOnly] =
      asyncRequestResponse[GetInstanceAccessRequest, GetInstanceAccessResponse](
        "getInstanceAccess",
        api.getInstanceAccess
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.GetInstanceAccessResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.gamelift.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def updateBuild(
        request: zio.aws.gamelift.model.UpdateBuildRequest
    ): IO[AwsError, zio.aws.gamelift.model.UpdateBuildResponse.ReadOnly] =
      asyncRequestResponse[UpdateBuildRequest, UpdateBuildResponse](
        "updateBuild",
        api.updateBuild
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.UpdateBuildResponse.wrap)
        .provideEnvironment(r)
    def describeEC2InstanceLimits(
        request: zio.aws.gamelift.model.DescribeEc2InstanceLimitsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeEc2InstanceLimitsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEc2InstanceLimitsRequest,
      DescribeEc2InstanceLimitsResponse
    ]("describeEC2InstanceLimits", api.describeEC2InstanceLimits)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeEc2InstanceLimitsResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.gamelift.model.TagResourceRequest
    ): IO[AwsError, zio.aws.gamelift.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeBuild(
        request: zio.aws.gamelift.model.DescribeBuildRequest
    ): IO[AwsError, zio.aws.gamelift.model.DescribeBuildResponse.ReadOnly] =
      asyncRequestResponse[DescribeBuildRequest, DescribeBuildResponse](
        "describeBuild",
        api.describeBuild
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.DescribeBuildResponse.wrap)
        .provideEnvironment(r)
    def describeGameSessions(
        request: zio.aws.gamelift.model.DescribeGameSessionsRequest
    ): ZStream[Any, AwsError, zio.aws.gamelift.model.GameSession.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeGameSessionsRequest,
        DescribeGameSessionsResponse,
        GameSession
      ](
        "describeGameSessions",
        api.describeGameSessions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.gameSessions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.gamelift.model.GameSession.wrap(item))
        .provideEnvironment(r)
    def describeGameSessionsPaginated(
        request: zio.aws.gamelift.model.DescribeGameSessionsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeGameSessionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeGameSessionsRequest,
      DescribeGameSessionsResponse
    ]("describeGameSessions", api.describeGameSessions)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.DescribeGameSessionsResponse.wrap)
      .provideEnvironment(r)
    def deleteAlias(
        request: zio.aws.gamelift.model.DeleteAliasRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteAliasRequest, DeleteAliasResponse](
        "deleteAlias",
        api.deleteAlias
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deregisterGameServer(
        request: zio.aws.gamelift.model.DeregisterGameServerRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeregisterGameServerRequest,
      DeregisterGameServerResponse
    ]("deregisterGameServer", api.deregisterGameServer)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createMatchmakingRuleSet(
        request: zio.aws.gamelift.model.CreateMatchmakingRuleSetRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.CreateMatchmakingRuleSetResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateMatchmakingRuleSetRequest,
      CreateMatchmakingRuleSetResponse
    ]("createMatchmakingRuleSet", api.createMatchmakingRuleSet)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.CreateMatchmakingRuleSetResponse.wrap)
      .provideEnvironment(r)
    def listGameServerGroups(
        request: zio.aws.gamelift.model.ListGameServerGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.gamelift.model.GameServerGroup.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListGameServerGroupsRequest,
        ListGameServerGroupsResponse,
        GameServerGroup
      ](
        "listGameServerGroups",
        api.listGameServerGroups,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.gameServerGroups().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.gamelift.model.GameServerGroup.wrap(item))
        .provideEnvironment(r)
    def listGameServerGroupsPaginated(
        request: zio.aws.gamelift.model.ListGameServerGroupsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.ListGameServerGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListGameServerGroupsRequest,
      ListGameServerGroupsResponse
    ]("listGameServerGroups", api.listGameServerGroups)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.ListGameServerGroupsResponse.wrap)
      .provideEnvironment(r)
    def createGameSession(
        request: zio.aws.gamelift.model.CreateGameSessionRequest
    ): IO[AwsError, zio.aws.gamelift.model.CreateGameSessionResponse.ReadOnly] =
      asyncRequestResponse[CreateGameSessionRequest, CreateGameSessionResponse](
        "createGameSession",
        api.createGameSession
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.CreateGameSessionResponse.wrap)
        .provideEnvironment(r)
    def describeFleetLocationAttributes(
        request: zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly,
      zio.aws.gamelift.model.LocationAttributes.ReadOnly
    ]] = asyncPaginatedRequest[
      DescribeFleetLocationAttributesRequest,
      DescribeFleetLocationAttributesResponse,
      LocationAttributes
    ](
      "describeFleetLocationAttributes",
      api.describeFleetLocationAttributes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.locationAttributes().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.gamelift.model.LocationAttributes.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeFleetLocationAttributesPaginated(
        request: zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetLocationAttributesRequest,
      DescribeFleetLocationAttributesResponse
    ]("describeFleetLocationAttributes", api.describeFleetLocationAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.wrap)
      .provideEnvironment(r)
    def describeScript(
        request: zio.aws.gamelift.model.DescribeScriptRequest
    ): IO[AwsError, zio.aws.gamelift.model.DescribeScriptResponse.ReadOnly] =
      asyncRequestResponse[DescribeScriptRequest, DescribeScriptResponse](
        "describeScript",
        api.describeScript
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.DescribeScriptResponse.wrap)
        .provideEnvironment(r)
    def describeGameServerInstances(
        request: zio.aws.gamelift.model.DescribeGameServerInstancesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameServerInstance.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeGameServerInstancesRequest,
      DescribeGameServerInstancesResponse,
      GameServerInstance
    ](
      "describeGameServerInstances",
      api.describeGameServerInstances,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.gameServerInstances().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.gamelift.model.GameServerInstance.wrap(item))
      .provideEnvironment(r)
    def describeGameServerInstancesPaginated(
        request: zio.aws.gamelift.model.DescribeGameServerInstancesRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeGameServerInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeGameServerInstancesRequest,
      DescribeGameServerInstancesResponse
    ]("describeGameServerInstances", api.describeGameServerInstances)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DescribeGameServerInstancesResponse.wrap)
      .provideEnvironment(r)
    def listBuilds(
        request: zio.aws.gamelift.model.ListBuildsRequest
    ): ZStream[Any, AwsError, zio.aws.gamelift.model.Build.ReadOnly] =
      asyncSimplePaginatedRequest[ListBuildsRequest, ListBuildsResponse, Build](
        "listBuilds",
        api.listBuilds,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.builds().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.gamelift.model.Build.wrap(item))
        .provideEnvironment(r)
    def listBuildsPaginated(
        request: zio.aws.gamelift.model.ListBuildsRequest
    ): IO[AwsError, zio.aws.gamelift.model.ListBuildsResponse.ReadOnly] =
      asyncRequestResponse[ListBuildsRequest, ListBuildsResponse](
        "listBuilds",
        api.listBuilds
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.ListBuildsResponse.wrap)
        .provideEnvironment(r)
    def getComputeAccess(
        request: zio.aws.gamelift.model.GetComputeAccessRequest
    ): IO[AwsError, zio.aws.gamelift.model.GetComputeAccessResponse.ReadOnly] =
      asyncRequestResponse[GetComputeAccessRequest, GetComputeAccessResponse](
        "getComputeAccess",
        api.getComputeAccess
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.GetComputeAccessResponse.wrap)
        .provideEnvironment(r)
    def acceptMatch(
        request: zio.aws.gamelift.model.AcceptMatchRequest
    ): IO[AwsError, zio.aws.gamelift.model.AcceptMatchResponse.ReadOnly] =
      asyncRequestResponse[AcceptMatchRequest, AcceptMatchResponse](
        "acceptMatch",
        api.acceptMatch
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.AcceptMatchResponse.wrap)
        .provideEnvironment(r)
    def deleteMatchmakingRuleSet(
        request: zio.aws.gamelift.model.DeleteMatchmakingRuleSetRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DeleteMatchmakingRuleSetResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteMatchmakingRuleSetRequest,
      DeleteMatchmakingRuleSetResponse
    ]("deleteMatchmakingRuleSet", api.deleteMatchmakingRuleSet)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.DeleteMatchmakingRuleSetResponse.wrap)
      .provideEnvironment(r)
    def updateMatchmakingConfiguration(
        request: zio.aws.gamelift.model.UpdateMatchmakingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.UpdateMatchmakingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateMatchmakingConfigurationRequest,
      UpdateMatchmakingConfigurationResponse
    ]("updateMatchmakingConfiguration", api.updateMatchmakingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.UpdateMatchmakingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def resolveAlias(
        request: zio.aws.gamelift.model.ResolveAliasRequest
    ): IO[AwsError, zio.aws.gamelift.model.ResolveAliasResponse.ReadOnly] =
      asyncRequestResponse[ResolveAliasRequest, ResolveAliasResponse](
        "resolveAlias",
        api.resolveAlias
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.ResolveAliasResponse.wrap)
        .provideEnvironment(r)
    def deleteScalingPolicy(
        request: zio.aws.gamelift.model.DeleteScalingPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteScalingPolicyRequest,
      DeleteScalingPolicyResponse
    ]("deleteScalingPolicy", api.deleteScalingPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listGameServers(
        request: zio.aws.gamelift.model.ListGameServersRequest
    ): ZStream[Any, AwsError, zio.aws.gamelift.model.GameServer.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListGameServersRequest,
        ListGameServersResponse,
        GameServer
      ](
        "listGameServers",
        api.listGameServers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.gameServers().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.gamelift.model.GameServer.wrap(item))
        .provideEnvironment(r)
    def listGameServersPaginated(
        request: zio.aws.gamelift.model.ListGameServersRequest
    ): IO[AwsError, zio.aws.gamelift.model.ListGameServersResponse.ReadOnly] =
      asyncRequestResponse[ListGameServersRequest, ListGameServersResponse](
        "listGameServers",
        api.listGameServers
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.ListGameServersResponse.wrap)
        .provideEnvironment(r)
    def updateFleetCapacity(
        request: zio.aws.gamelift.model.UpdateFleetCapacityRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.UpdateFleetCapacityResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateFleetCapacityRequest,
      UpdateFleetCapacityResponse
    ]("updateFleetCapacity", api.updateFleetCapacity)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.UpdateFleetCapacityResponse.wrap)
      .provideEnvironment(r)
    def updateGameServerGroup(
        request: zio.aws.gamelift.model.UpdateGameServerGroupRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.UpdateGameServerGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateGameServerGroupRequest,
      UpdateGameServerGroupResponse
    ]("updateGameServerGroup", api.updateGameServerGroup)(
      request.buildAwsValue()
    ).map(zio.aws.gamelift.model.UpdateGameServerGroupResponse.wrap)
      .provideEnvironment(r)
    def describeFleetEvents(
        request: zio.aws.gamelift.model.DescribeFleetEventsRequest
    ): ZStream[Any, AwsError, zio.aws.gamelift.model.Event.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeFleetEventsRequest,
        DescribeFleetEventsResponse,
        Event
      ](
        "describeFleetEvents",
        api.describeFleetEvents,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.events().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.gamelift.model.Event.wrap(item))
        .provideEnvironment(r)
    def describeFleetEventsPaginated(
        request: zio.aws.gamelift.model.DescribeFleetEventsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeFleetEventsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetEventsRequest,
      DescribeFleetEventsResponse
    ]("describeFleetEvents", api.describeFleetEvents)(request.buildAwsValue())
      .map(zio.aws.gamelift.model.DescribeFleetEventsResponse.wrap)
      .provideEnvironment(r)
    def updateScript(
        request: zio.aws.gamelift.model.UpdateScriptRequest
    ): IO[AwsError, zio.aws.gamelift.model.UpdateScriptResponse.ReadOnly] =
      asyncRequestResponse[UpdateScriptRequest, UpdateScriptResponse](
        "updateScript",
        api.updateScript
      )(request.buildAwsValue())
        .map(zio.aws.gamelift.model.UpdateScriptResponse.wrap)
        .provideEnvironment(r)
    def describeMatchmakingConfigurations(
        request: zio.aws.gamelift.model.DescribeMatchmakingConfigurationsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      DescribeMatchmakingConfigurationsRequest,
      DescribeMatchmakingConfigurationsResponse,
      MatchmakingConfiguration
    ](
      "describeMatchmakingConfigurations",
      api.describeMatchmakingConfigurations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.configurations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.gamelift.model.MatchmakingConfiguration.wrap(item))
      .provideEnvironment(r)
    def describeMatchmakingConfigurationsPaginated(
        request: zio.aws.gamelift.model.DescribeMatchmakingConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.gamelift.model.DescribeMatchmakingConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMatchmakingConfigurationsRequest,
      DescribeMatchmakingConfigurationsResponse
    ](
      "describeMatchmakingConfigurations",
      api.describeMatchmakingConfigurations
    )(request.buildAwsValue())
      .map(
        zio.aws.gamelift.model.DescribeMatchmakingConfigurationsResponse.wrap
      )
      .provideEnvironment(r)
  }
  def deleteBuild(
      request: zio.aws.gamelift.model.DeleteBuildRequest
  ): ZIO[zio.aws.gamelift.GameLift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBuild(request))
  def describeVpcPeeringConnections(
      request: zio.aws.gamelift.model.DescribeVpcPeeringConnectionsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeVpcPeeringConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVpcPeeringConnections(request))
  def startMatchmaking(
      request: zio.aws.gamelift.model.StartMatchmakingRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.StartMatchmakingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startMatchmaking(request))
  def updateGameServer(
      request: zio.aws.gamelift.model.UpdateGameServerRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.UpdateGameServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGameServer(request))
  def getComputeAuthToken(
      request: zio.aws.gamelift.model.GetComputeAuthTokenRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.GetComputeAuthTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComputeAuthToken(request))
  def updateFleetPortSettings(
      request: zio.aws.gamelift.model.UpdateFleetPortSettingsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.UpdateFleetPortSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFleetPortSettings(request))
  def describeMatchmaking(
      request: zio.aws.gamelift.model.DescribeMatchmakingRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeMatchmakingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMatchmaking(request))
  def createGameSessionQueue(
      request: zio.aws.gamelift.model.CreateGameSessionQueueRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.CreateGameSessionQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGameSessionQueue(request))
  def updateRuntimeConfiguration(
      request: zio.aws.gamelift.model.UpdateRuntimeConfigurationRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.UpdateRuntimeConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRuntimeConfiguration(request))
  def registerCompute(
      request: zio.aws.gamelift.model.RegisterComputeRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.RegisterComputeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerCompute(request))
  def deleteScript(
      request: zio.aws.gamelift.model.DeleteScriptRequest
  ): ZIO[zio.aws.gamelift.GameLift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteScript(request))
  def createPlayerSessions(
      request: zio.aws.gamelift.model.CreatePlayerSessionsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.CreatePlayerSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPlayerSessions(request))
  def stopFleetActions(
      request: zio.aws.gamelift.model.StopFleetActionsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.StopFleetActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopFleetActions(request))
  def describeInstances(
      request: zio.aws.gamelift.model.DescribeInstancesRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.Instance.ReadOnly
  ] = ZStream.serviceWithStream(_.describeInstances(request))
  def describeInstancesPaginated(
      request: zio.aws.gamelift.model.DescribeInstancesRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstancesPaginated(request))
  def suspendGameServerGroup(
      request: zio.aws.gamelift.model.SuspendGameServerGroupRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.SuspendGameServerGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.suspendGameServerGroup(request))
  def describeGameSessionDetails(
      request: zio.aws.gamelift.model.DescribeGameSessionDetailsRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.GameSessionDetail.ReadOnly
  ] = ZStream.serviceWithStream(_.describeGameSessionDetails(request))
  def describeGameSessionDetailsPaginated(
      request: zio.aws.gamelift.model.DescribeGameSessionDetailsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeGameSessionDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGameSessionDetailsPaginated(request))
  def createGameServerGroup(
      request: zio.aws.gamelift.model.CreateGameServerGroupRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.CreateGameServerGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGameServerGroup(request))
  def createScript(request: zio.aws.gamelift.model.CreateScriptRequest): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.CreateScriptResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createScript(request))
  def describeCompute(
      request: zio.aws.gamelift.model.DescribeComputeRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeComputeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCompute(request))
  def deregisterCompute(
      request: zio.aws.gamelift.model.DeregisterComputeRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DeregisterComputeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterCompute(request))
  def searchGameSessions(
      request: zio.aws.gamelift.model.SearchGameSessionsRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.GameSession.ReadOnly
  ] = ZStream.serviceWithStream(_.searchGameSessions(request))
  def searchGameSessionsPaginated(
      request: zio.aws.gamelift.model.SearchGameSessionsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.SearchGameSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchGameSessionsPaginated(request))
  def startMatchBackfill(
      request: zio.aws.gamelift.model.StartMatchBackfillRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.StartMatchBackfillResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startMatchBackfill(request))
  def listFleets(
      request: zio.aws.gamelift.model.ListFleetsRequest
  ): ZStream[zio.aws.gamelift.GameLift, AwsError, FleetId] =
    ZStream.serviceWithStream(_.listFleets(request))
  def listFleetsPaginated(
      request: zio.aws.gamelift.model.ListFleetsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.ListFleetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFleetsPaginated(request))
  def describeFleetUtilization(
      request: zio.aws.gamelift.model.DescribeFleetUtilizationRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.FleetUtilization.ReadOnly
  ] = ZStream.serviceWithStream(_.describeFleetUtilization(request))
  def describeFleetUtilizationPaginated(
      request: zio.aws.gamelift.model.DescribeFleetUtilizationRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeFleetUtilizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetUtilizationPaginated(request))
  def createPlayerSession(
      request: zio.aws.gamelift.model.CreatePlayerSessionRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.CreatePlayerSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPlayerSession(request))
  def describeGameSessionPlacement(
      request: zio.aws.gamelift.model.DescribeGameSessionPlacementRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeGameSessionPlacementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGameSessionPlacement(request))
  def listLocations(
      request: zio.aws.gamelift.model.ListLocationsRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.LocationModel.ReadOnly
  ] = ZStream.serviceWithStream(_.listLocations(request))
  def listLocationsPaginated(
      request: zio.aws.gamelift.model.ListLocationsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.ListLocationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLocationsPaginated(request))
  def updateGameSession(
      request: zio.aws.gamelift.model.UpdateGameSessionRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.UpdateGameSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGameSession(request))
  def createVpcPeeringAuthorization(
      request: zio.aws.gamelift.model.CreateVpcPeeringAuthorizationRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.CreateVpcPeeringAuthorizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpcPeeringAuthorization(request))
  def describeFleetLocationCapacity(
      request: zio.aws.gamelift.model.DescribeFleetLocationCapacityRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeFleetLocationCapacityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetLocationCapacity(request))
  def listCompute(request: zio.aws.gamelift.model.ListComputeRequest): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.Compute.ReadOnly
  ] = ZStream.serviceWithStream(_.listCompute(request))
  def listComputePaginated(
      request: zio.aws.gamelift.model.ListComputeRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.ListComputeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComputePaginated(request))
  def listScripts(request: zio.aws.gamelift.model.ListScriptsRequest): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.Script.ReadOnly
  ] = ZStream.serviceWithStream(_.listScripts(request))
  def listScriptsPaginated(
      request: zio.aws.gamelift.model.ListScriptsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.ListScriptsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listScriptsPaginated(request))
  def describeVpcPeeringAuthorizations(
      request: zio.aws.gamelift.model.DescribeVpcPeeringAuthorizationsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeVpcPeeringAuthorizationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVpcPeeringAuthorizations(request))
  def createBuild(request: zio.aws.gamelift.model.CreateBuildRequest): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.CreateBuildResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBuild(request))
  def deleteFleet(
      request: zio.aws.gamelift.model.DeleteFleetRequest
  ): ZIO[zio.aws.gamelift.GameLift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFleet(request))
  def describeMatchmakingRuleSets(
      request: zio.aws.gamelift.model.DescribeMatchmakingRuleSetsRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.MatchmakingRuleSet.ReadOnly
  ] = ZStream.serviceWithStream(_.describeMatchmakingRuleSets(request))
  def describeMatchmakingRuleSetsPaginated(
      request: zio.aws.gamelift.model.DescribeMatchmakingRuleSetsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeMatchmakingRuleSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMatchmakingRuleSetsPaginated(request))
  def putScalingPolicy(
      request: zio.aws.gamelift.model.PutScalingPolicyRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.PutScalingPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putScalingPolicy(request))
  def deleteGameServerGroup(
      request: zio.aws.gamelift.model.DeleteGameServerGroupRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DeleteGameServerGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGameServerGroup(request))
  def updateGameSessionQueue(
      request: zio.aws.gamelift.model.UpdateGameSessionQueueRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.UpdateGameSessionQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGameSessionQueue(request))
  def stopGameSessionPlacement(
      request: zio.aws.gamelift.model.StopGameSessionPlacementRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.StopGameSessionPlacementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopGameSessionPlacement(request))
  def createLocation(
      request: zio.aws.gamelift.model.CreateLocationRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.CreateLocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLocation(request))
  def describeGameServerGroup(
      request: zio.aws.gamelift.model.DescribeGameServerGroupRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeGameServerGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGameServerGroup(request))
  def deleteVpcPeeringAuthorization(
      request: zio.aws.gamelift.model.DeleteVpcPeeringAuthorizationRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DeleteVpcPeeringAuthorizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVpcPeeringAuthorization(request))
  def registerGameServer(
      request: zio.aws.gamelift.model.RegisterGameServerRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.RegisterGameServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerGameServer(request))
  def describeFleetAttributes(
      request: zio.aws.gamelift.model.DescribeFleetAttributesRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.FleetAttributes.ReadOnly
  ] = ZStream.serviceWithStream(_.describeFleetAttributes(request))
  def describeFleetAttributesPaginated(
      request: zio.aws.gamelift.model.DescribeFleetAttributesRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeFleetAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetAttributesPaginated(request))
  def deleteVpcPeeringConnection(
      request: zio.aws.gamelift.model.DeleteVpcPeeringConnectionRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DeleteVpcPeeringConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVpcPeeringConnection(request))
  def describeRuntimeConfiguration(
      request: zio.aws.gamelift.model.DescribeRuntimeConfigurationRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeRuntimeConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRuntimeConfiguration(request))
  def listAliases(request: zio.aws.gamelift.model.ListAliasesRequest): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.Alias.ReadOnly
  ] = ZStream.serviceWithStream(_.listAliases(request))
  def listAliasesPaginated(
      request: zio.aws.gamelift.model.ListAliasesRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.ListAliasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAliasesPaginated(request))
  def getGameSessionLogUrl(
      request: zio.aws.gamelift.model.GetGameSessionLogUrlRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.GetGameSessionLogUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGameSessionLogUrl(request))
  def describeAlias(request: zio.aws.gamelift.model.DescribeAliasRequest): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAlias(request))
  def deleteLocation(
      request: zio.aws.gamelift.model.DeleteLocationRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DeleteLocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLocation(request))
  def createFleet(request: zio.aws.gamelift.model.CreateFleetRequest): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.CreateFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFleet(request))
  def describeScalingPolicies(
      request: zio.aws.gamelift.model.DescribeScalingPoliciesRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.ScalingPolicy.ReadOnly
  ] = ZStream.serviceWithStream(_.describeScalingPolicies(request))
  def describeScalingPoliciesPaginated(
      request: zio.aws.gamelift.model.DescribeScalingPoliciesRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeScalingPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeScalingPoliciesPaginated(request))
  def updateAlias(request: zio.aws.gamelift.model.UpdateAliasRequest): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.UpdateAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAlias(request))
  def untagResource(request: zio.aws.gamelift.model.UntagResourceRequest): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createAlias(request: zio.aws.gamelift.model.CreateAliasRequest): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.CreateAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAlias(request))
  def updateFleetAttributes(
      request: zio.aws.gamelift.model.UpdateFleetAttributesRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.UpdateFleetAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFleetAttributes(request))
  def describeFleetLocationUtilization(
      request: zio.aws.gamelift.model.DescribeFleetLocationUtilizationRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeFleetLocationUtilizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetLocationUtilization(request))
  def describeGameServer(
      request: zio.aws.gamelift.model.DescribeGameServerRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeGameServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGameServer(request))
  def deleteGameSessionQueue(
      request: zio.aws.gamelift.model.DeleteGameSessionQueueRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DeleteGameSessionQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGameSessionQueue(request))
  def startFleetActions(
      request: zio.aws.gamelift.model.StartFleetActionsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.StartFleetActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startFleetActions(request))
  def requestUploadCredentials(
      request: zio.aws.gamelift.model.RequestUploadCredentialsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.RequestUploadCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.requestUploadCredentials(request))
  def deleteFleetLocations(
      request: zio.aws.gamelift.model.DeleteFleetLocationsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DeleteFleetLocationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFleetLocations(request))
  def describePlayerSessions(
      request: zio.aws.gamelift.model.DescribePlayerSessionsRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.PlayerSession.ReadOnly
  ] = ZStream.serviceWithStream(_.describePlayerSessions(request))
  def describePlayerSessionsPaginated(
      request: zio.aws.gamelift.model.DescribePlayerSessionsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribePlayerSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePlayerSessionsPaginated(request))
  def resumeGameServerGroup(
      request: zio.aws.gamelift.model.ResumeGameServerGroupRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.ResumeGameServerGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resumeGameServerGroup(request))
  def startGameSessionPlacement(
      request: zio.aws.gamelift.model.StartGameSessionPlacementRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.StartGameSessionPlacementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startGameSessionPlacement(request))
  def createVpcPeeringConnection(
      request: zio.aws.gamelift.model.CreateVpcPeeringConnectionRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.CreateVpcPeeringConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpcPeeringConnection(request))
  def stopMatchmaking(
      request: zio.aws.gamelift.model.StopMatchmakingRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.StopMatchmakingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopMatchmaking(request))
  def claimGameServer(
      request: zio.aws.gamelift.model.ClaimGameServerRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.ClaimGameServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.claimGameServer(request))
  def describeFleetCapacity(
      request: zio.aws.gamelift.model.DescribeFleetCapacityRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.FleetCapacity.ReadOnly
  ] = ZStream.serviceWithStream(_.describeFleetCapacity(request))
  def describeFleetCapacityPaginated(
      request: zio.aws.gamelift.model.DescribeFleetCapacityRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeFleetCapacityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetCapacityPaginated(request))
  def validateMatchmakingRuleSet(
      request: zio.aws.gamelift.model.ValidateMatchmakingRuleSetRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.ValidateMatchmakingRuleSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.validateMatchmakingRuleSet(request))
  def deleteMatchmakingConfiguration(
      request: zio.aws.gamelift.model.DeleteMatchmakingConfigurationRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DeleteMatchmakingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMatchmakingConfiguration(request))
  def describeFleetPortSettings(
      request: zio.aws.gamelift.model.DescribeFleetPortSettingsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeFleetPortSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetPortSettings(request))
  def describeGameSessionQueues(
      request: zio.aws.gamelift.model.DescribeGameSessionQueuesRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.GameSessionQueue.ReadOnly
  ] = ZStream.serviceWithStream(_.describeGameSessionQueues(request))
  def describeGameSessionQueuesPaginated(
      request: zio.aws.gamelift.model.DescribeGameSessionQueuesRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeGameSessionQueuesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGameSessionQueuesPaginated(request))
  def createFleetLocations(
      request: zio.aws.gamelift.model.CreateFleetLocationsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.CreateFleetLocationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFleetLocations(request))
  def createMatchmakingConfiguration(
      request: zio.aws.gamelift.model.CreateMatchmakingConfigurationRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.CreateMatchmakingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMatchmakingConfiguration(request))
  def getInstanceAccess(
      request: zio.aws.gamelift.model.GetInstanceAccessRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.GetInstanceAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInstanceAccess(request))
  def listTagsForResource(
      request: zio.aws.gamelift.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def updateBuild(request: zio.aws.gamelift.model.UpdateBuildRequest): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.UpdateBuildResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBuild(request))
  def describeEC2InstanceLimits(
      request: zio.aws.gamelift.model.DescribeEc2InstanceLimitsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeEc2InstanceLimitsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEC2InstanceLimits(request))
  def tagResource(request: zio.aws.gamelift.model.TagResourceRequest): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def describeBuild(request: zio.aws.gamelift.model.DescribeBuildRequest): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeBuildResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBuild(request))
  def describeGameSessions(
      request: zio.aws.gamelift.model.DescribeGameSessionsRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.GameSession.ReadOnly
  ] = ZStream.serviceWithStream(_.describeGameSessions(request))
  def describeGameSessionsPaginated(
      request: zio.aws.gamelift.model.DescribeGameSessionsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeGameSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGameSessionsPaginated(request))
  def deleteAlias(
      request: zio.aws.gamelift.model.DeleteAliasRequest
  ): ZIO[zio.aws.gamelift.GameLift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAlias(request))
  def deregisterGameServer(
      request: zio.aws.gamelift.model.DeregisterGameServerRequest
  ): ZIO[zio.aws.gamelift.GameLift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deregisterGameServer(request))
  def createMatchmakingRuleSet(
      request: zio.aws.gamelift.model.CreateMatchmakingRuleSetRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.CreateMatchmakingRuleSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMatchmakingRuleSet(request))
  def listGameServerGroups(
      request: zio.aws.gamelift.model.ListGameServerGroupsRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.GameServerGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.listGameServerGroups(request))
  def listGameServerGroupsPaginated(
      request: zio.aws.gamelift.model.ListGameServerGroupsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.ListGameServerGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGameServerGroupsPaginated(request))
  def createGameSession(
      request: zio.aws.gamelift.model.CreateGameSessionRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.CreateGameSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGameSession(request))
  def describeFleetLocationAttributes(
      request: zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest
  ): ZIO[zio.aws.gamelift.GameLift, AwsError, StreamingOutputResult[
    Any,
    zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly,
    zio.aws.gamelift.model.LocationAttributes.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeFleetLocationAttributes(request))
  def describeFleetLocationAttributesPaginated(
      request: zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeFleetLocationAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetLocationAttributesPaginated(request))
  def describeScript(
      request: zio.aws.gamelift.model.DescribeScriptRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeScriptResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeScript(request))
  def describeGameServerInstances(
      request: zio.aws.gamelift.model.DescribeGameServerInstancesRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.GameServerInstance.ReadOnly
  ] = ZStream.serviceWithStream(_.describeGameServerInstances(request))
  def describeGameServerInstancesPaginated(
      request: zio.aws.gamelift.model.DescribeGameServerInstancesRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeGameServerInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGameServerInstancesPaginated(request))
  def listBuilds(request: zio.aws.gamelift.model.ListBuildsRequest): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.Build.ReadOnly
  ] = ZStream.serviceWithStream(_.listBuilds(request))
  def listBuildsPaginated(
      request: zio.aws.gamelift.model.ListBuildsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.ListBuildsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBuildsPaginated(request))
  def getComputeAccess(
      request: zio.aws.gamelift.model.GetComputeAccessRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.GetComputeAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComputeAccess(request))
  def acceptMatch(request: zio.aws.gamelift.model.AcceptMatchRequest): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.AcceptMatchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptMatch(request))
  def deleteMatchmakingRuleSet(
      request: zio.aws.gamelift.model.DeleteMatchmakingRuleSetRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DeleteMatchmakingRuleSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMatchmakingRuleSet(request))
  def updateMatchmakingConfiguration(
      request: zio.aws.gamelift.model.UpdateMatchmakingConfigurationRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.UpdateMatchmakingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMatchmakingConfiguration(request))
  def resolveAlias(request: zio.aws.gamelift.model.ResolveAliasRequest): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.ResolveAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resolveAlias(request))
  def deleteScalingPolicy(
      request: zio.aws.gamelift.model.DeleteScalingPolicyRequest
  ): ZIO[zio.aws.gamelift.GameLift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteScalingPolicy(request))
  def listGameServers(
      request: zio.aws.gamelift.model.ListGameServersRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.GameServer.ReadOnly
  ] = ZStream.serviceWithStream(_.listGameServers(request))
  def listGameServersPaginated(
      request: zio.aws.gamelift.model.ListGameServersRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.ListGameServersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGameServersPaginated(request))
  def updateFleetCapacity(
      request: zio.aws.gamelift.model.UpdateFleetCapacityRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.UpdateFleetCapacityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFleetCapacity(request))
  def updateGameServerGroup(
      request: zio.aws.gamelift.model.UpdateGameServerGroupRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.UpdateGameServerGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGameServerGroup(request))
  def describeFleetEvents(
      request: zio.aws.gamelift.model.DescribeFleetEventsRequest
  ): ZStream[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.Event.ReadOnly
  ] = ZStream.serviceWithStream(_.describeFleetEvents(request))
  def describeFleetEventsPaginated(
      request: zio.aws.gamelift.model.DescribeFleetEventsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeFleetEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetEventsPaginated(request))
  def updateScript(request: zio.aws.gamelift.model.UpdateScriptRequest): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.UpdateScriptResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateScript(request))
  def describeMatchmakingConfigurations(
      request: zio.aws.gamelift.model.DescribeMatchmakingConfigurationsRequest
  ): ZStream[zio.aws.gamelift.GameLift, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.describeMatchmakingConfigurations(request))
  def describeMatchmakingConfigurationsPaginated(
      request: zio.aws.gamelift.model.DescribeMatchmakingConfigurationsRequest
  ): ZIO[
    zio.aws.gamelift.GameLift,
    AwsError,
    zio.aws.gamelift.model.DescribeMatchmakingConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMatchmakingConfigurationsPaginated(request))
}
