package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  MatchmakingIdStringModel
}
import scala.jdk.CollectionConverters._
final case class AcceptMatchRequest(
    ticketId: MatchmakingIdStringModel,
    playerIds: Iterable[NonZeroAndMaxString],
    acceptanceType: zio.aws.gamelift.model.AcceptanceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.AcceptMatchRequest = {
    import AcceptMatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.AcceptMatchRequest
      .builder()
      .ticketId(MatchmakingIdStringModel.unwrap(ticketId): java.lang.String)
      .playerIds(playerIds.map { item =>
        NonZeroAndMaxString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .acceptanceType(acceptanceType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.AcceptMatchRequest.ReadOnly =
    zio.aws.gamelift.model.AcceptMatchRequest.wrap(buildAwsValue())
}
object AcceptMatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.AcceptMatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.AcceptMatchRequest =
      zio.aws.gamelift.model
        .AcceptMatchRequest(ticketId, playerIds, acceptanceType)
    def ticketId: MatchmakingIdStringModel
    def playerIds: List[NonZeroAndMaxString]
    def acceptanceType: zio.aws.gamelift.model.AcceptanceType
    def getTicketId: ZIO[Any, Nothing, MatchmakingIdStringModel] =
      ZIO.succeed(ticketId)
    def getPlayerIds: ZIO[Any, Nothing, List[NonZeroAndMaxString]] =
      ZIO.succeed(playerIds)
    def getAcceptanceType
        : ZIO[Any, Nothing, zio.aws.gamelift.model.AcceptanceType] =
      ZIO.succeed(acceptanceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.AcceptMatchRequest
  ) extends zio.aws.gamelift.model.AcceptMatchRequest.ReadOnly {
    override val ticketId: MatchmakingIdStringModel =
      zio.aws.gamelift.model.primitives
        .MatchmakingIdStringModel(impl.ticketId())
    override val playerIds: List[NonZeroAndMaxString] = impl
      .playerIds()
      .asScala
      .map { item =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(item)
      }
      .toList
    override val acceptanceType: zio.aws.gamelift.model.AcceptanceType =
      zio.aws.gamelift.model.AcceptanceType.wrap(impl.acceptanceType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.AcceptMatchRequest
  ): zio.aws.gamelift.model.AcceptMatchRequest.ReadOnly = new Wrapper(impl)
}
