package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  AliasArn,
  FreeText,
  Timestamp,
  AliasId,
  NonBlankAndLengthConstraintString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Alias(
    aliasId: Optional[AliasId] = Optional.Absent,
    name: Optional[NonBlankAndLengthConstraintString] = Optional.Absent,
    aliasArn: Optional[AliasArn] = Optional.Absent,
    description: Optional[FreeText] = Optional.Absent,
    routingStrategy: Optional[zio.aws.gamelift.model.RoutingStrategy] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.gamelift.model.Alias = {
    import Alias.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.Alias
      .builder()
      .optionallyWith(
        aliasId.map(value => AliasId.unwrap(value): java.lang.String)
      )(_.aliasId)
      .optionallyWith(
        name.map(value =>
          NonBlankAndLengthConstraintString.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        aliasArn.map(value => AliasArn.unwrap(value): java.lang.String)
      )(_.aliasArn)
      .optionallyWith(
        description.map(value => FreeText.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(routingStrategy.map(value => value.buildAwsValue()))(
        _.routingStrategy
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.Alias.ReadOnly =
    zio.aws.gamelift.model.Alias.wrap(buildAwsValue())
}
object Alias {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.gamelift.model.Alias] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.Alias = zio.aws.gamelift.model.Alias(
      aliasId.map(value => value),
      name.map(value => value),
      aliasArn.map(value => value),
      description.map(value => value),
      routingStrategy.map(value => value.asEditable),
      creationTime.map(value => value),
      lastUpdatedTime.map(value => value)
    )
    def aliasId: Optional[AliasId]
    def name: Optional[NonBlankAndLengthConstraintString]
    def aliasArn: Optional[AliasArn]
    def description: Optional[FreeText]
    def routingStrategy
        : Optional[zio.aws.gamelift.model.RoutingStrategy.ReadOnly]
    def creationTime: Optional[Timestamp]
    def lastUpdatedTime: Optional[Timestamp]
    def getAliasId: ZIO[Any, AwsError, AliasId] =
      AwsError.unwrapOptionField("aliasId", aliasId)
    def getName: ZIO[Any, AwsError, NonBlankAndLengthConstraintString] =
      AwsError.unwrapOptionField("name", name)
    def getAliasArn: ZIO[Any, AwsError, AliasArn] =
      AwsError.unwrapOptionField("aliasArn", aliasArn)
    def getDescription: ZIO[Any, AwsError, FreeText] =
      AwsError.unwrapOptionField("description", description)
    def getRoutingStrategy
        : ZIO[Any, AwsError, zio.aws.gamelift.model.RoutingStrategy.ReadOnly] =
      AwsError.unwrapOptionField("routingStrategy", routingStrategy)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.Alias
  ) extends zio.aws.gamelift.model.Alias.ReadOnly {
    override val aliasId: Optional[AliasId] = zio.aws.core.internal
      .optionalFromNullable(impl.aliasId())
      .map(value => zio.aws.gamelift.model.primitives.AliasId(value))
    override val name: Optional[NonBlankAndLengthConstraintString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.gamelift.model.primitives
            .NonBlankAndLengthConstraintString(value)
        )
    override val aliasArn: Optional[AliasArn] = zio.aws.core.internal
      .optionalFromNullable(impl.aliasArn())
      .map(value => zio.aws.gamelift.model.primitives.AliasArn(value))
    override val description: Optional[FreeText] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.gamelift.model.primitives.FreeText(value))
    override val routingStrategy
        : Optional[zio.aws.gamelift.model.RoutingStrategy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingStrategy())
        .map(value => zio.aws.gamelift.model.RoutingStrategy.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.Alias
  ): zio.aws.gamelift.model.Alias.ReadOnly = new Wrapper(impl)
}
