package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.NonNegativeLimitedLengthDouble
import scala.jdk.CollectionConverters._
final case class AnywhereConfiguration(cost: NonNegativeLimitedLengthDouble) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.AnywhereConfiguration = {
    import AnywhereConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.AnywhereConfiguration
      .builder()
      .cost(NonNegativeLimitedLengthDouble.unwrap(cost): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.AnywhereConfiguration.ReadOnly =
    zio.aws.gamelift.model.AnywhereConfiguration.wrap(buildAwsValue())
}
object AnywhereConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.AnywhereConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.AnywhereConfiguration =
      zio.aws.gamelift.model.AnywhereConfiguration(cost)
    def cost: NonNegativeLimitedLengthDouble
    def getCost: ZIO[Any, Nothing, NonNegativeLimitedLengthDouble] =
      ZIO.succeed(cost)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.AnywhereConfiguration
  ) extends zio.aws.gamelift.model.AnywhereConfiguration.ReadOnly {
    override val cost: NonNegativeLimitedLengthDouble =
      zio.aws.gamelift.model.primitives
        .NonNegativeLimitedLengthDouble(impl.cost())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.AnywhereConfiguration
  ): zio.aws.gamelift.model.AnywhereConfiguration.ReadOnly = new Wrapper(impl)
}
