package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAliasResponse(
    alias: Optional[zio.aws.gamelift.model.Alias] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateAliasResponse = {
    import CreateAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateAliasResponse
      .builder()
      .optionallyWith(alias.map(value => value.buildAwsValue()))(_.alias)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateAliasResponse.ReadOnly =
    zio.aws.gamelift.model.CreateAliasResponse.wrap(buildAwsValue())
}
object CreateAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateAliasResponse =
      zio.aws.gamelift.model
        .CreateAliasResponse(alias.map(value => value.asEditable))
    def alias: Optional[zio.aws.gamelift.model.Alias.ReadOnly]
    def getAlias: ZIO[Any, AwsError, zio.aws.gamelift.model.Alias.ReadOnly] =
      AwsError.unwrapOptionField("alias", alias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateAliasResponse
  ) extends zio.aws.gamelift.model.CreateAliasResponse.ReadOnly {
    override val alias: Optional[zio.aws.gamelift.model.Alias.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alias())
        .map(value => zio.aws.gamelift.model.Alias.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateAliasResponse
  ): zio.aws.gamelift.model.CreateAliasResponse.ReadOnly = new Wrapper(impl)
}
