package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.FleetIdOrArn
import scala.jdk.CollectionConverters._
final case class CreateFleetLocationsRequest(
    fleetId: FleetIdOrArn,
    locations: Iterable[zio.aws.gamelift.model.LocationConfiguration]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateFleetLocationsRequest = {
    import CreateFleetLocationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateFleetLocationsRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .locations(locations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateFleetLocationsRequest.ReadOnly =
    zio.aws.gamelift.model.CreateFleetLocationsRequest.wrap(buildAwsValue())
}
object CreateFleetLocationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateFleetLocationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateFleetLocationsRequest =
      zio.aws.gamelift.model.CreateFleetLocationsRequest(
        fleetId,
        locations.map { item =>
          item.asEditable
        }
      )
    def fleetId: FleetIdOrArn
    def locations: List[zio.aws.gamelift.model.LocationConfiguration.ReadOnly]
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getLocations: ZIO[Any, Nothing, List[
      zio.aws.gamelift.model.LocationConfiguration.ReadOnly
    ]] = ZIO.succeed(locations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateFleetLocationsRequest
  ) extends zio.aws.gamelift.model.CreateFleetLocationsRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val locations
        : List[zio.aws.gamelift.model.LocationConfiguration.ReadOnly] = impl
      .locations()
      .asScala
      .map { item =>
        zio.aws.gamelift.model.LocationConfiguration.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateFleetLocationsRequest
  ): zio.aws.gamelift.model.CreateFleetLocationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
