package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFleetResponse(
    fleetAttributes: Optional[zio.aws.gamelift.model.FleetAttributes] =
      Optional.Absent,
    locationStates: Optional[Iterable[zio.aws.gamelift.model.LocationState]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateFleetResponse = {
    import CreateFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateFleetResponse
      .builder()
      .optionallyWith(fleetAttributes.map(value => value.buildAwsValue()))(
        _.fleetAttributes
      )
      .optionallyWith(
        locationStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.locationStates)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateFleetResponse.ReadOnly =
    zio.aws.gamelift.model.CreateFleetResponse.wrap(buildAwsValue())
}
object CreateFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateFleetResponse =
      zio.aws.gamelift.model.CreateFleetResponse(
        fleetAttributes.map(value => value.asEditable),
        locationStates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fleetAttributes
        : Optional[zio.aws.gamelift.model.FleetAttributes.ReadOnly]
    def locationStates
        : Optional[List[zio.aws.gamelift.model.LocationState.ReadOnly]]
    def getFleetAttributes
        : ZIO[Any, AwsError, zio.aws.gamelift.model.FleetAttributes.ReadOnly] =
      AwsError.unwrapOptionField("fleetAttributes", fleetAttributes)
    def getLocationStates: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.LocationState.ReadOnly
    ]] = AwsError.unwrapOptionField("locationStates", locationStates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateFleetResponse
  ) extends zio.aws.gamelift.model.CreateFleetResponse.ReadOnly {
    override val fleetAttributes
        : Optional[zio.aws.gamelift.model.FleetAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleetAttributes())
        .map(value => zio.aws.gamelift.model.FleetAttributes.wrap(value))
    override val locationStates
        : Optional[List[zio.aws.gamelift.model.LocationState.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locationStates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.LocationState.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateFleetResponse
  ): zio.aws.gamelift.model.CreateFleetResponse.ReadOnly = new Wrapper(impl)
}
