package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  ArnStringModel,
  SnsArnStringModel,
  CustomEventData,
  WholeNumber,
  MatchmakingAcceptanceTimeoutInteger,
  BooleanModel,
  GameSessionData,
  NonZeroAndMaxString,
  MatchmakingRequestTimeoutInteger,
  MatchmakingIdStringModel,
  MatchmakingRuleSetName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateMatchmakingConfigurationRequest(
    name: MatchmakingIdStringModel,
    description: Optional[NonZeroAndMaxString] = Optional.Absent,
    gameSessionQueueArns: Optional[Iterable[ArnStringModel]] = Optional.Absent,
    requestTimeoutSeconds: MatchmakingRequestTimeoutInteger,
    acceptanceTimeoutSeconds: Optional[MatchmakingAcceptanceTimeoutInteger] =
      Optional.Absent,
    acceptanceRequired: BooleanModel,
    ruleSetName: MatchmakingRuleSetName,
    notificationTarget: Optional[SnsArnStringModel] = Optional.Absent,
    additionalPlayerCount: Optional[WholeNumber] = Optional.Absent,
    customEventData: Optional[CustomEventData] = Optional.Absent,
    gameProperties: Optional[Iterable[zio.aws.gamelift.model.GameProperty]] =
      Optional.Absent,
    gameSessionData: Optional[GameSessionData] = Optional.Absent,
    backfillMode: Optional[zio.aws.gamelift.model.BackfillMode] =
      Optional.Absent,
    flexMatchMode: Optional[zio.aws.gamelift.model.FlexMatchMode] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.gamelift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationRequest = {
    import CreateMatchmakingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationRequest
      .builder()
      .name(MatchmakingIdStringModel.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        gameSessionQueueArns.map(value =>
          value.map { item =>
            ArnStringModel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.gameSessionQueueArns)
      .requestTimeoutSeconds(
        MatchmakingRequestTimeoutInteger.unwrap(requestTimeoutSeconds): Integer
      )
      .optionallyWith(
        acceptanceTimeoutSeconds.map(value =>
          MatchmakingAcceptanceTimeoutInteger.unwrap(value): Integer
        )
      )(_.acceptanceTimeoutSeconds)
      .acceptanceRequired(
        BooleanModel.unwrap(acceptanceRequired): java.lang.Boolean
      )
      .ruleSetName(MatchmakingRuleSetName.unwrap(ruleSetName): java.lang.String)
      .optionallyWith(
        notificationTarget.map(value =>
          SnsArnStringModel.unwrap(value): java.lang.String
        )
      )(_.notificationTarget)
      .optionallyWith(
        additionalPlayerCount.map(value => WholeNumber.unwrap(value): Integer)
      )(_.additionalPlayerCount)
      .optionallyWith(
        customEventData.map(value =>
          CustomEventData.unwrap(value): java.lang.String
        )
      )(_.customEventData)
      .optionallyWith(
        gameProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameProperties)
      .optionallyWith(
        gameSessionData.map(value =>
          GameSessionData.unwrap(value): java.lang.String
        )
      )(_.gameSessionData)
      .optionallyWith(backfillMode.map(value => value.unwrap))(_.backfillMode)
      .optionallyWith(flexMatchMode.map(value => value.unwrap))(_.flexMatchMode)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.CreateMatchmakingConfigurationRequest.ReadOnly =
    zio.aws.gamelift.model.CreateMatchmakingConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateMatchmakingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.CreateMatchmakingConfigurationRequest =
      zio.aws.gamelift.model.CreateMatchmakingConfigurationRequest(
        name,
        description.map(value => value),
        gameSessionQueueArns.map(value => value),
        requestTimeoutSeconds,
        acceptanceTimeoutSeconds.map(value => value),
        acceptanceRequired,
        ruleSetName,
        notificationTarget.map(value => value),
        additionalPlayerCount.map(value => value),
        customEventData.map(value => value),
        gameProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gameSessionData.map(value => value),
        backfillMode.map(value => value),
        flexMatchMode.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: MatchmakingIdStringModel
    def description: Optional[NonZeroAndMaxString]
    def gameSessionQueueArns: Optional[List[ArnStringModel]]
    def requestTimeoutSeconds: MatchmakingRequestTimeoutInteger
    def acceptanceTimeoutSeconds: Optional[MatchmakingAcceptanceTimeoutInteger]
    def acceptanceRequired: BooleanModel
    def ruleSetName: MatchmakingRuleSetName
    def notificationTarget: Optional[SnsArnStringModel]
    def additionalPlayerCount: Optional[WholeNumber]
    def customEventData: Optional[CustomEventData]
    def gameProperties
        : Optional[List[zio.aws.gamelift.model.GameProperty.ReadOnly]]
    def gameSessionData: Optional[GameSessionData]
    def backfillMode: Optional[zio.aws.gamelift.model.BackfillMode]
    def flexMatchMode: Optional[zio.aws.gamelift.model.FlexMatchMode]
    def tags: Optional[List[zio.aws.gamelift.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, MatchmakingIdStringModel] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("description", description)
    def getGameSessionQueueArns: ZIO[Any, AwsError, List[ArnStringModel]] =
      AwsError.unwrapOptionField("gameSessionQueueArns", gameSessionQueueArns)
    def getRequestTimeoutSeconds
        : ZIO[Any, Nothing, MatchmakingRequestTimeoutInteger] =
      ZIO.succeed(requestTimeoutSeconds)
    def getAcceptanceTimeoutSeconds
        : ZIO[Any, AwsError, MatchmakingAcceptanceTimeoutInteger] = AwsError
      .unwrapOptionField("acceptanceTimeoutSeconds", acceptanceTimeoutSeconds)
    def getAcceptanceRequired: ZIO[Any, Nothing, BooleanModel] =
      ZIO.succeed(acceptanceRequired)
    def getRuleSetName: ZIO[Any, Nothing, MatchmakingRuleSetName] =
      ZIO.succeed(ruleSetName)
    def getNotificationTarget: ZIO[Any, AwsError, SnsArnStringModel] =
      AwsError.unwrapOptionField("notificationTarget", notificationTarget)
    def getAdditionalPlayerCount: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("additionalPlayerCount", additionalPlayerCount)
    def getCustomEventData: ZIO[Any, AwsError, CustomEventData] =
      AwsError.unwrapOptionField("customEventData", customEventData)
    def getGameProperties: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("gameProperties", gameProperties)
    def getGameSessionData: ZIO[Any, AwsError, GameSessionData] =
      AwsError.unwrapOptionField("gameSessionData", gameSessionData)
    def getBackfillMode
        : ZIO[Any, AwsError, zio.aws.gamelift.model.BackfillMode] =
      AwsError.unwrapOptionField("backfillMode", backfillMode)
    def getFlexMatchMode
        : ZIO[Any, AwsError, zio.aws.gamelift.model.FlexMatchMode] =
      AwsError.unwrapOptionField("flexMatchMode", flexMatchMode)
    def getTags: ZIO[Any, AwsError, List[zio.aws.gamelift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationRequest
  ) extends zio.aws.gamelift.model.CreateMatchmakingConfigurationRequest.ReadOnly {
    override val name: MatchmakingIdStringModel =
      zio.aws.gamelift.model.primitives.MatchmakingIdStringModel(impl.name())
    override val description: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val gameSessionQueueArns: Optional[List[ArnStringModel]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionQueueArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.primitives.ArnStringModel(item)
          }.toList
        )
    override val requestTimeoutSeconds: MatchmakingRequestTimeoutInteger =
      zio.aws.gamelift.model.primitives
        .MatchmakingRequestTimeoutInteger(impl.requestTimeoutSeconds())
    override val acceptanceTimeoutSeconds
        : Optional[MatchmakingAcceptanceTimeoutInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptanceTimeoutSeconds())
      .map(value =>
        zio.aws.gamelift.model.primitives
          .MatchmakingAcceptanceTimeoutInteger(value)
      )
    override val acceptanceRequired: BooleanModel =
      zio.aws.gamelift.model.primitives.BooleanModel(impl.acceptanceRequired())
    override val ruleSetName: MatchmakingRuleSetName =
      zio.aws.gamelift.model.primitives
        .MatchmakingRuleSetName(impl.ruleSetName())
    override val notificationTarget: Optional[SnsArnStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationTarget())
        .map(value =>
          zio.aws.gamelift.model.primitives.SnsArnStringModel(value)
        )
    override val additionalPlayerCount: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalPlayerCount())
        .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val customEventData: Optional[CustomEventData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customEventData())
        .map(value => zio.aws.gamelift.model.primitives.CustomEventData(value))
    override val gameProperties
        : Optional[List[zio.aws.gamelift.model.GameProperty.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameProperties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.GameProperty.wrap(item)
          }.toList
        )
    override val gameSessionData: Optional[GameSessionData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionData())
        .map(value => zio.aws.gamelift.model.primitives.GameSessionData(value))
    override val backfillMode: Optional[zio.aws.gamelift.model.BackfillMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backfillMode())
        .map(value => zio.aws.gamelift.model.BackfillMode.wrap(value))
    override val flexMatchMode: Optional[zio.aws.gamelift.model.FlexMatchMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flexMatchMode())
        .map(value => zio.aws.gamelift.model.FlexMatchMode.wrap(value))
    override val tags: Optional[List[zio.aws.gamelift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationRequest
  ): zio.aws.gamelift.model.CreateMatchmakingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
