package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.{NonZeroAndMaxString, FleetId}
import scala.jdk.CollectionConverters._
final case class CreateVpcPeeringConnectionRequest(
    fleetId: FleetId,
    peerVpcAwsAccountId: NonZeroAndMaxString,
    peerVpcId: NonZeroAndMaxString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionRequest = {
    import CreateVpcPeeringConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionRequest
      .builder()
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .peerVpcAwsAccountId(
        NonZeroAndMaxString.unwrap(peerVpcAwsAccountId): java.lang.String
      )
      .peerVpcId(NonZeroAndMaxString.unwrap(peerVpcId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.CreateVpcPeeringConnectionRequest.ReadOnly =
    zio.aws.gamelift.model.CreateVpcPeeringConnectionRequest
      .wrap(buildAwsValue())
}
object CreateVpcPeeringConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateVpcPeeringConnectionRequest =
      zio.aws.gamelift.model.CreateVpcPeeringConnectionRequest(
        fleetId,
        peerVpcAwsAccountId,
        peerVpcId
      )
    def fleetId: FleetId
    def peerVpcAwsAccountId: NonZeroAndMaxString
    def peerVpcId: NonZeroAndMaxString
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getPeerVpcAwsAccountId: ZIO[Any, Nothing, NonZeroAndMaxString] =
      ZIO.succeed(peerVpcAwsAccountId)
    def getPeerVpcId: ZIO[Any, Nothing, NonZeroAndMaxString] =
      ZIO.succeed(peerVpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionRequest
  ) extends zio.aws.gamelift.model.CreateVpcPeeringConnectionRequest.ReadOnly {
    override val fleetId: FleetId =
      zio.aws.gamelift.model.primitives.FleetId(impl.fleetId())
    override val peerVpcAwsAccountId: NonZeroAndMaxString =
      zio.aws.gamelift.model.primitives
        .NonZeroAndMaxString(impl.peerVpcAwsAccountId())
    override val peerVpcId: NonZeroAndMaxString =
      zio.aws.gamelift.model.primitives.NonZeroAndMaxString(impl.peerVpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionRequest
  ): zio.aws.gamelift.model.CreateVpcPeeringConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
