package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{FleetArn, FleetIdOrArn}
import scala.jdk.CollectionConverters._
final case class DeleteFleetLocationsResponse(
    fleetId: Optional[FleetIdOrArn] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent,
    locationStates: Optional[Iterable[zio.aws.gamelift.model.LocationState]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsResponse = {
    import DeleteFleetLocationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsResponse
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetIdOrArn.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(
        locationStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.locationStates)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DeleteFleetLocationsResponse.ReadOnly =
    zio.aws.gamelift.model.DeleteFleetLocationsResponse.wrap(buildAwsValue())
}
object DeleteFleetLocationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DeleteFleetLocationsResponse =
      zio.aws.gamelift.model.DeleteFleetLocationsResponse(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        locationStates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fleetId: Optional[FleetIdOrArn]
    def fleetArn: Optional[FleetArn]
    def locationStates
        : Optional[List[zio.aws.gamelift.model.LocationState.ReadOnly]]
    def getFleetId: ZIO[Any, AwsError, FleetIdOrArn] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getLocationStates: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.LocationState.ReadOnly
    ]] = AwsError.unwrapOptionField("locationStates", locationStates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsResponse
  ) extends zio.aws.gamelift.model.DeleteFleetLocationsResponse.ReadOnly {
    override val fleetId: Optional[FleetIdOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetIdOrArn(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val locationStates
        : Optional[List[zio.aws.gamelift.model.LocationState.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locationStates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.LocationState.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsResponse
  ): zio.aws.gamelift.model.DeleteFleetLocationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
