package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.GameServerGroupNameOrArn
import scala.jdk.CollectionConverters._
final case class DeleteGameServerGroupRequest(
    gameServerGroupName: GameServerGroupNameOrArn,
    deleteOption: Optional[zio.aws.gamelift.model.GameServerGroupDeleteOption] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupRequest = {
    import DeleteGameServerGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupRequest
      .builder()
      .gameServerGroupName(
        GameServerGroupNameOrArn.unwrap(gameServerGroupName): java.lang.String
      )
      .optionallyWith(deleteOption.map(value => value.unwrap))(_.deleteOption)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DeleteGameServerGroupRequest.ReadOnly =
    zio.aws.gamelift.model.DeleteGameServerGroupRequest.wrap(buildAwsValue())
}
object DeleteGameServerGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DeleteGameServerGroupRequest =
      zio.aws.gamelift.model.DeleteGameServerGroupRequest(
        gameServerGroupName,
        deleteOption.map(value => value)
      )
    def gameServerGroupName: GameServerGroupNameOrArn
    def deleteOption
        : Optional[zio.aws.gamelift.model.GameServerGroupDeleteOption]
    def getGameServerGroupName: ZIO[Any, Nothing, GameServerGroupNameOrArn] =
      ZIO.succeed(gameServerGroupName)
    def getDeleteOption: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameServerGroupDeleteOption
    ] = AwsError.unwrapOptionField("deleteOption", deleteOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupRequest
  ) extends zio.aws.gamelift.model.DeleteGameServerGroupRequest.ReadOnly {
    override val gameServerGroupName: GameServerGroupNameOrArn =
      zio.aws.gamelift.model.primitives
        .GameServerGroupNameOrArn(impl.gameServerGroupName())
    override val deleteOption
        : Optional[zio.aws.gamelift.model.GameServerGroupDeleteOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteOption())
        .map(value =>
          zio.aws.gamelift.model.GameServerGroupDeleteOption.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupRequest
  ): zio.aws.gamelift.model.DeleteGameServerGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
