package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.MatchmakingConfigurationName
import scala.jdk.CollectionConverters._
final case class DeleteMatchmakingConfigurationRequest(
    name: MatchmakingConfigurationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationRequest = {
    import DeleteMatchmakingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationRequest
      .builder()
      .name(MatchmakingConfigurationName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DeleteMatchmakingConfigurationRequest.ReadOnly =
    zio.aws.gamelift.model.DeleteMatchmakingConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteMatchmakingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DeleteMatchmakingConfigurationRequest =
      zio.aws.gamelift.model.DeleteMatchmakingConfigurationRequest(name)
    def name: MatchmakingConfigurationName
    def getName: ZIO[Any, Nothing, MatchmakingConfigurationName] =
      ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationRequest
  ) extends zio.aws.gamelift.model.DeleteMatchmakingConfigurationRequest.ReadOnly {
    override val name: MatchmakingConfigurationName =
      zio.aws.gamelift.model.primitives
        .MatchmakingConfigurationName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationRequest
  ): zio.aws.gamelift.model.DeleteMatchmakingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
