package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class DeleteVpcPeeringAuthorizationRequest(
    gameLiftAwsAccountId: NonZeroAndMaxString,
    peerVpcId: NonZeroAndMaxString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationRequest = {
    import DeleteVpcPeeringAuthorizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationRequest
      .builder()
      .gameLiftAwsAccountId(
        NonZeroAndMaxString.unwrap(gameLiftAwsAccountId): java.lang.String
      )
      .peerVpcId(NonZeroAndMaxString.unwrap(peerVpcId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DeleteVpcPeeringAuthorizationRequest.ReadOnly =
    zio.aws.gamelift.model.DeleteVpcPeeringAuthorizationRequest
      .wrap(buildAwsValue())
}
object DeleteVpcPeeringAuthorizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DeleteVpcPeeringAuthorizationRequest =
      zio.aws.gamelift.model
        .DeleteVpcPeeringAuthorizationRequest(gameLiftAwsAccountId, peerVpcId)
    def gameLiftAwsAccountId: NonZeroAndMaxString
    def peerVpcId: NonZeroAndMaxString
    def getGameLiftAwsAccountId: ZIO[Any, Nothing, NonZeroAndMaxString] =
      ZIO.succeed(gameLiftAwsAccountId)
    def getPeerVpcId: ZIO[Any, Nothing, NonZeroAndMaxString] =
      ZIO.succeed(peerVpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationRequest
  ) extends zio.aws.gamelift.model.DeleteVpcPeeringAuthorizationRequest.ReadOnly {
    override val gameLiftAwsAccountId: NonZeroAndMaxString =
      zio.aws.gamelift.model.primitives
        .NonZeroAndMaxString(impl.gameLiftAwsAccountId())
    override val peerVpcId: NonZeroAndMaxString =
      zio.aws.gamelift.model.primitives.NonZeroAndMaxString(impl.peerVpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationRequest
  ): zio.aws.gamelift.model.DeleteVpcPeeringAuthorizationRequest.ReadOnly =
    new Wrapper(impl)
}
