package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.{ComputeNameOrArn, FleetIdOrArn}
import scala.jdk.CollectionConverters._
final case class DeregisterComputeRequest(
    fleetId: FleetIdOrArn,
    computeName: ComputeNameOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeregisterComputeRequest = {
    import DeregisterComputeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeregisterComputeRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .computeName(ComputeNameOrArn.unwrap(computeName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DeregisterComputeRequest.ReadOnly =
    zio.aws.gamelift.model.DeregisterComputeRequest.wrap(buildAwsValue())
}
object DeregisterComputeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeregisterComputeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DeregisterComputeRequest =
      zio.aws.gamelift.model.DeregisterComputeRequest(fleetId, computeName)
    def fleetId: FleetIdOrArn
    def computeName: ComputeNameOrArn
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getComputeName: ZIO[Any, Nothing, ComputeNameOrArn] =
      ZIO.succeed(computeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeregisterComputeRequest
  ) extends zio.aws.gamelift.model.DeregisterComputeRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val computeName: ComputeNameOrArn =
      zio.aws.gamelift.model.primitives.ComputeNameOrArn(impl.computeName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeregisterComputeRequest
  ): zio.aws.gamelift.model.DeregisterComputeRequest.ReadOnly = new Wrapper(
    impl
  )
}
