package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.{
  GameServerId,
  GameServerGroupNameOrArn
}
import scala.jdk.CollectionConverters._
final case class DeregisterGameServerRequest(
    gameServerGroupName: GameServerGroupNameOrArn,
    gameServerId: GameServerId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeregisterGameServerRequest = {
    import DeregisterGameServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeregisterGameServerRequest
      .builder()
      .gameServerGroupName(
        GameServerGroupNameOrArn.unwrap(gameServerGroupName): java.lang.String
      )
      .gameServerId(GameServerId.unwrap(gameServerId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DeregisterGameServerRequest.ReadOnly =
    zio.aws.gamelift.model.DeregisterGameServerRequest.wrap(buildAwsValue())
}
object DeregisterGameServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeregisterGameServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DeregisterGameServerRequest =
      zio.aws.gamelift.model
        .DeregisterGameServerRequest(gameServerGroupName, gameServerId)
    def gameServerGroupName: GameServerGroupNameOrArn
    def gameServerId: GameServerId
    def getGameServerGroupName: ZIO[Any, Nothing, GameServerGroupNameOrArn] =
      ZIO.succeed(gameServerGroupName)
    def getGameServerId: ZIO[Any, Nothing, GameServerId] =
      ZIO.succeed(gameServerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeregisterGameServerRequest
  ) extends zio.aws.gamelift.model.DeregisterGameServerRequest.ReadOnly {
    override val gameServerGroupName: GameServerGroupNameOrArn =
      zio.aws.gamelift.model.primitives
        .GameServerGroupNameOrArn(impl.gameServerGroupName())
    override val gameServerId: GameServerId =
      zio.aws.gamelift.model.primitives.GameServerId(impl.gameServerId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeregisterGameServerRequest
  ): zio.aws.gamelift.model.DeregisterGameServerRequest.ReadOnly = new Wrapper(
    impl
  )
}
