package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeComputeResponse(
    compute: Optional[zio.aws.gamelift.model.Compute] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeComputeResponse = {
    import DescribeComputeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeComputeResponse
      .builder()
      .optionallyWith(compute.map(value => value.buildAwsValue()))(_.compute)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DescribeComputeResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeComputeResponse.wrap(buildAwsValue())
}
object DescribeComputeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeComputeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeComputeResponse =
      zio.aws.gamelift.model
        .DescribeComputeResponse(compute.map(value => value.asEditable))
    def compute: Optional[zio.aws.gamelift.model.Compute.ReadOnly]
    def getCompute
        : ZIO[Any, AwsError, zio.aws.gamelift.model.Compute.ReadOnly] =
      AwsError.unwrapOptionField("compute", compute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeComputeResponse
  ) extends zio.aws.gamelift.model.DescribeComputeResponse.ReadOnly {
    override val compute: Optional[zio.aws.gamelift.model.Compute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compute())
        .map(value => zio.aws.gamelift.model.Compute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeComputeResponse
  ): zio.aws.gamelift.model.DescribeComputeResponse.ReadOnly = new Wrapper(impl)
}
