package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class DescribeFleetCapacityResponse(
    fleetCapacity: Optional[Iterable[zio.aws.gamelift.model.FleetCapacity]] =
      Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse = {
    import DescribeFleetCapacityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse
      .builder()
      .optionallyWith(
        fleetCapacity.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fleetCapacity)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeFleetCapacityResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeFleetCapacityResponse.wrap(buildAwsValue())
}
object DescribeFleetCapacityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeFleetCapacityResponse =
      zio.aws.gamelift.model.DescribeFleetCapacityResponse(
        fleetCapacity.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fleetCapacity
        : Optional[List[zio.aws.gamelift.model.FleetCapacity.ReadOnly]]
    def nextToken: Optional[NonZeroAndMaxString]
    def getFleetCapacity: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.FleetCapacity.ReadOnly
    ]] = AwsError.unwrapOptionField("fleetCapacity", fleetCapacity)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse
  ) extends zio.aws.gamelift.model.DescribeFleetCapacityResponse.ReadOnly {
    override val fleetCapacity
        : Optional[List[zio.aws.gamelift.model.FleetCapacity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleetCapacity())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.FleetCapacity.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse
  ): zio.aws.gamelift.model.DescribeFleetCapacityResponse.ReadOnly =
    new Wrapper(impl)
}
