package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeFleetLocationUtilizationResponse(
    fleetUtilization: Optional[zio.aws.gamelift.model.FleetUtilization] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationResponse = {
    import DescribeFleetLocationUtilizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationResponse
      .builder()
      .optionallyWith(fleetUtilization.map(value => value.buildAwsValue()))(
        _.fleetUtilization
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeFleetLocationUtilizationResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeFleetLocationUtilizationResponse
      .wrap(buildAwsValue())
}
object DescribeFleetLocationUtilizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DescribeFleetLocationUtilizationResponse =
      zio.aws.gamelift.model.DescribeFleetLocationUtilizationResponse(
        fleetUtilization.map(value => value.asEditable)
      )
    def fleetUtilization
        : Optional[zio.aws.gamelift.model.FleetUtilization.ReadOnly]
    def getFleetUtilization
        : ZIO[Any, AwsError, zio.aws.gamelift.model.FleetUtilization.ReadOnly] =
      AwsError.unwrapOptionField("fleetUtilization", fleetUtilization)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationResponse
  ) extends zio.aws.gamelift.model.DescribeFleetLocationUtilizationResponse.ReadOnly {
    override val fleetUtilization
        : Optional[zio.aws.gamelift.model.FleetUtilization.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleetUtilization())
        .map(value => zio.aws.gamelift.model.FleetUtilization.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationResponse
  ): zio.aws.gamelift.model.DescribeFleetLocationUtilizationResponse.ReadOnly =
    new Wrapper(impl)
}
